/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.log.Log;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.TimeoutCapable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TimeoutManager {
    private static final String LOG_CATEGORY = "Timeout";
    private ScheduledThreadPoolExecutor timeoutService;

    public TimeoutManager() {
        this(null);
    }

    public TimeoutManager(ThreadFactory tf2) {
        this(tf2, 1);
    }

    public TimeoutManager(ThreadFactory tf2, int numberOfThreads) {
        if (tf2 == null) {
            tf2 = new MonitorThreadFactory();
        }
        if (numberOfThreads < 1) {
            numberOfThreads = 1;
        }
        this.timeoutService = new ScheduledThreadPoolExecutor(numberOfThreads, tf2);
    }

    public Future scheduleTimeout(TimeoutCapable t10) {
        ScheduledFuture<?> future = null;
        if (t10.getTimeoutPeriod() > 0L) {
            TimeoutTask timeoutTask = new TimeoutTask(t10);
            future = this.timeoutService.schedule(timeoutTask, t10.getTimeoutPeriod(), TimeUnit.MILLISECONDS);
            t10.setTimeoutFuture(future);
            if (t10 instanceof TimeoutAbstractObject) {
                TimeoutAbstractObject timeoutAbstract = (TimeoutAbstractObject)t10;
                timeoutAbstract.setTimeoutManager(this);
                timeoutAbstract.setTimeoutTask(timeoutTask);
            }
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' has scheduled instance '" + System.identityHashCode(t10) + "' of type '" + t10.getClass().getName() + "' to be timed out in " + t10.getTimeoutPeriod() + " milliseconds. Task queue size: " + this.timeoutService.getQueue().size());
            }
        }
        return future;
    }

    public boolean unscheduleTimeout(TimeoutAbstractObject timeoutAbstract) {
        Runnable unscheduledTimeoutTask;
        Object toRemove = timeoutAbstract.getTimeoutFuture();
        if (!(toRemove instanceof Runnable)) {
            toRemove = timeoutAbstract.getTimeoutTask();
        }
        if (this.timeoutService.remove((Runnable)toRemove)) {
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' has removed the timeout task for instance '" + System.identityHashCode(timeoutAbstract) + "' of type '" + timeoutAbstract.getClass().getName() + "' that has requested its timeout be cancelled. Task queue size: " + this.timeoutService.getQueue().size());
            }
        } else {
            Future timeoutFuture = timeoutAbstract.getTimeoutFuture();
            timeoutFuture.cancel(false);
            if (Log.isDebug()) {
                Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' cancelling timeout task for instance '" + System.identityHashCode(timeoutAbstract) + "' of type '" + timeoutAbstract.getClass().getName() + "' that has requested its timeout be cancelled. Task queue size: " + this.timeoutService.getQueue().size());
            }
            if (timeoutFuture.isDone()) {
                this.timeoutService.purge();
                if (Log.isDebug()) {
                    Log.getLogger(LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(this) + "' purged queue of any cancelled or completed tasks. Task queue size: " + this.timeoutService.getQueue().size());
                }
            }
        }
        if ((unscheduledTimeoutTask = timeoutAbstract.getTimeoutTask()) != null && unscheduledTimeoutTask instanceof TimeoutTask) {
            ((TimeoutTask)timeoutAbstract.getTimeoutTask()).clearTimeoutCapable();
        }
        return true;
    }

    public void shutdown() {
        this.timeoutService.shutdownNow();
    }

    class TimeoutTask
    implements Runnable {
        private TimeoutCapable timeoutObject;

        public void clearTimeoutCapable() {
            this.timeoutObject = null;
        }

        public TimeoutTask(TimeoutCapable timeoutObject) {
            this.timeoutObject = timeoutObject;
        }

        public void run() {
            block6: {
                long inactiveMillis = System.currentTimeMillis() - this.timeoutObject.getLastUse();
                if (inactiveMillis >= this.timeoutObject.getTimeoutPeriod()) {
                    try {
                        this.timeoutObject.timeout();
                        if (Log.isDebug()) {
                            Log.getLogger(TimeoutManager.LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' has run the timeout task for instance '" + System.identityHashCode(this.timeoutObject) + "' of type '" + this.timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size());
                        }
                        break block6;
                    }
                    catch (Throwable t10) {
                        if (Log.isError()) {
                            Log.getLogger(TimeoutManager.LOG_CATEGORY).error("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' encountered an error running the timeout task for instance '" + System.identityHashCode(this.timeoutObject) + "' of type '" + this.timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size(), t10);
                        }
                        break block6;
                    }
                }
                this.timeoutObject.setTimeoutFuture(TimeoutManager.this.timeoutService.schedule(this, this.timeoutObject.getTimeoutPeriod() - inactiveMillis, TimeUnit.MILLISECONDS));
                if (Log.isDebug()) {
                    Log.getLogger(TimeoutManager.LOG_CATEGORY).debug("TimeoutManager '" + System.identityHashCode(TimeoutManager.this) + "' has rescheduled a timeout for the active instance '" + System.identityHashCode(this.timeoutObject) + "' of type '" + this.timeoutObject.getClass().getName() + "'. Task queue size: " + TimeoutManager.this.timeoutService.getQueue().size());
                }
            }
        }
    }

    class MonitorThreadFactory
    implements ThreadFactory {
        MonitorThreadFactory() {
        }

        public Thread newThread(Runnable r10) {
            Thread t10 = new Thread(r10);
            t10.setDaemon(true);
            t10.setName("TimeoutManager");
            return t10;
        }
    }
}

