/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.remoting;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.io.PageableRowSet;
import flex.messaging.io.PagedRowSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.RowSet;

public class PageableRowSetCache {
    private static final int DEFAULT_PAGE_SIZE = 25;

    public static PageableRowSet cacheRowSet(RowSet rowset, int pageSize) {
        if (pageSize <= 0) {
            pageSize = 25;
        }
        PagedRowSet prs = new PagedRowSet(rowset, pageSize, true);
        PageableRowSetCache.cachePageableRowSet(prs);
        return prs;
    }

    public static void cachePageableRowSet(PageableRowSet rowset) {
        if (rowset != null) {
            FlexSession session = FlexContext.getFlexSession();
            session.setAttribute(rowset.getID(), rowset);
        }
    }

    public Map getRecords(String id2, int startIndex, int count) throws SQLException {
        Object o10;
        Map page = null;
        FlexSession session = FlexContext.getFlexSession();
        if (session != null && (o10 = session.getAttribute(id2)) != null && o10 instanceof PageableRowSet) {
            PageableRowSet rs2 = (PageableRowSet)o10;
            page = rs2.getRecords(startIndex, count);
        }
        return page;
    }

    public void release(String id2) {
        FlexSession session = FlexContext.getFlexSession();
        if (session != null) {
            session.removeAttribute(id2);
        }
    }
}

