/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitsInfo {
    private final String className;
    private final boolean dynamic;
    private final boolean externalizable;
    private List<String> properties;

    public TraitsInfo(String className) {
        this(className, false, false, 10);
    }

    public TraitsInfo(String className, int initialCount) {
        this(className, false, false, initialCount);
    }

    public TraitsInfo(String className, boolean dynamic, boolean externalizable, int initialCount) {
        this(className, dynamic, externalizable, new ArrayList<String>(initialCount));
    }

    public TraitsInfo(String className, boolean dynamic, boolean externalizable, List<String> properties) {
        if (className == null) {
            className = "";
        }
        this.className = className;
        this.properties = properties;
        this.dynamic = dynamic;
        this.externalizable = externalizable;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public int length() {
        return this.properties != null ? this.properties.size() : 0;
    }

    public String getClassName() {
        return this.className;
    }

    public void addProperty(String name) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.add(name);
    }

    public void addAllProperties(Collection props) {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        this.properties.addAll(props);
    }

    public String getProperty(int i10) {
        return this.properties != null ? this.properties.get(i10) : null;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TraitsInfo) {
            TraitsInfo other = (TraitsInfo)obj;
            if (!this.className.equals(other.className)) {
                return false;
            }
            if (this.dynamic != other.dynamic) {
                return false;
            }
            List<String> thisProperties = this.properties;
            List<String> otherProperties = other.properties;
            if (thisProperties != otherProperties) {
                int thisCount = thisProperties.size();
                if (thisCount != otherProperties.size()) {
                    return false;
                }
                for (int i10 = 0; i10 < thisCount; ++i10) {
                    String thisProp = thisProperties.get(i10);
                    String otherProp = otherProperties.get(i10);
                    if (thisProp == null || otherProp == null || thisProp.equals(otherProp)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int size = this.properties != null ? this.properties.size() : 0;
        int c10 = this.className.hashCode();
        c10 = this.dynamic ? c10 << 2 : c10 << 1;
        return c10 |= size << 24;
    }
}

