/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ArrayList;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;

public class StatusInfoProxy
extends AbstractProxy {
    static final long serialVersionUID = 8860353096401173320L;
    public static final String DESCRIPTION = "description";
    public static final String DETAILS = "details";
    public static final String CLASS = "type";
    public static final String CODE = "code";
    public static final String ROOTCAUSE = "rootcause";
    public static final List propertyNameCache = new ArrayList();
    protected boolean showStacktraces;

    public StatusInfoProxy() {
        super(null);
    }

    public StatusInfoProxy(Throwable defaultInstance) {
        super(defaultInstance);
    }

    public void setShowStacktraces(boolean value) {
        this.showStacktraces = value;
    }

    public String getAlias(Object instance) {
        return null;
    }

    public List getPropertyNames(Object instance) {
        return propertyNameCache;
    }

    public Class getType(Object instance, String propertyName) {
        Class type = null;
        if (CODE.equals(propertyName)) {
            type = String.class;
        } else if (CLASS.equals(propertyName)) {
            type = String.class;
        } else if (DESCRIPTION.equals(propertyName)) {
            type = String.class;
        } else if (DETAILS.equals(propertyName)) {
            type = String.class;
        } else if (ROOTCAUSE.equals(propertyName)) {
            type = Map.class;
        }
        return type;
    }

    public Object getValue(Object instance, String propertyName) {
        Object value = null;
        if (CODE.equals(propertyName)) {
            value = this.getCode(instance);
        } else if (CLASS.equals(propertyName)) {
            value = this.getType(instance);
        } else if (DESCRIPTION.equals(propertyName)) {
            value = this.getDescription(instance);
        } else if (DETAILS.equals(propertyName)) {
            value = this.getDetails(instance);
        } else if (ROOTCAUSE.equals(propertyName)) {
            value = this.getRootCause(instance);
        }
        return value;
    }

    public void setValue(Object instance, String propertyName, Object value) {
    }

    private String getCode(Object ex2) {
        String code = null;
        if (ex2 instanceof MessageException) {
            code = ((MessageException)ex2).getCode();
        }
        if (code == null) {
            code = "Server.Processing";
        }
        return code;
    }

    private String getType(Object ex2) {
        String type = "";
        if (ex2 != null && this.showStacktraces) {
            type = ex2.getClass().getName();
        }
        return type;
    }

    private String getDescription(Object ex2) {
        String desc = null;
        if (ex2 instanceof Throwable) {
            desc = ((Throwable)ex2).getMessage();
        }
        return desc;
    }

    private String getDetails(Object ex2) {
        MessageException e10;
        StringBuffer details = new StringBuffer();
        if (ex2 instanceof MessageException && (e10 = (MessageException)ex2).getDetails() != null) {
            details.append(e10.getDetails());
        }
        if (this.showStacktraces && ex2 instanceof Throwable) {
            details.append(StatusInfoProxy.getTraceback((Throwable)ex2));
        }
        return details.toString();
    }

    private Map getRootCause(Object ex2) {
        if (ex2 == null) {
            return null;
        }
        if (ex2 instanceof ServletException) {
            ex2 = ((ServletException)ex2).getRootCause();
        }
        if (ex2 instanceof Throwable) {
            return this.getExceptionInfo((Throwable)ex2);
        }
        return null;
    }

    private Map getExceptionInfo(Throwable t10) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put(CODE, this.getCode(t10));
        info.put(CLASS, this.getType(t10));
        info.put(DESCRIPTION, this.getDescription(t10));
        info.put(DETAILS, this.getDetails(t10));
        info.put(ROOTCAUSE, this.getRootCause(t10));
        return info;
    }

    private static String getTraceback(Throwable e10) {
        String trace = "";
        if (e10 != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter pr2 = new PrintWriter(outputStream);
            pr2.println();
            e10.printStackTrace(pr2);
            pr2.flush();
            trace = outputStream.toString();
        }
        return trace;
    }

    public Object clone() {
        return super.clone();
    }

    static {
        propertyNameCache.add(CODE);
        propertyNameCache.add(CLASS);
        propertyNameCache.add(DESCRIPTION);
        propertyNameCache.add(DETAILS);
        propertyNameCache.add(ROOTCAUSE);
    }
}

