/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.AbstractMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class SerializationFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10306;
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private Logger logger;

    public SerializationFilter(String logCategory) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger(logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(ActionContext context) throws IOException {
        SerializationContext sc2;
        AmfTrace debugTrace;
        block38: {
            boolean success = false;
            debugTrace = Log.isDebug() && this.logger.hasTarget() ? new AmfTrace() : null;
            context.setResponseMessage(new ActionMessage());
            sc2 = SerializationContext.getSerializationContext();
            try {
                try {
                    MessageDeserializer deserializer = sc2.newMessageDeserializer();
                    ServletInputStream in2 = FlexContext.getHttpRequest().getInputStream();
                    deserializer.initialize(sc2, (InputStream)in2, debugTrace);
                    int reqLen = FlexContext.getHttpRequest().getContentLength();
                    context.setDeserializedBytes(reqLen);
                    if (context.isMPIenabled()) {
                        MessagePerformanceInfo mpi = new MessagePerformanceInfo();
                        mpi.recordMessageSizes = context.isRecordMessageSizes();
                        mpi.recordMessageTimes = context.isRecordMessageTimes();
                        if (context.isRecordMessageTimes()) {
                            mpi.receiveTime = System.currentTimeMillis();
                        }
                        if (context.isRecordMessageSizes()) {
                            mpi.messageSize = reqLen;
                        }
                        context.setMPII(mpi);
                    }
                    ActionMessage m10 = new ActionMessage();
                    context.setRequestMessage(m10);
                    deserializer.readMessage(m10, context);
                    success = true;
                }
                catch (Throwable t10) {
                    SerializationFilter.handleDeserializationException(context, t10, this.logger);
                    Object var10_12 = null;
                    ActionMessage respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (debugTrace != null) {
                        this.logger.debug(debugTrace.toString());
                    }
                }
                Object var10_11 = null;
                ActionMessage respMsg = context.getResponseMessage();
                respMsg.setVersion(context.getVersion());
                if (debugTrace != null) {
                    this.logger.debug(debugTrace.toString());
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                ActionMessage respMsg = context.getResponseMessage();
                respMsg.setVersion(context.getVersion());
                if (debugTrace == null) throw throwable;
                this.logger.debug(debugTrace.toString());
                throw throwable;
            }
            if (!success) break block38;
            this.next.invoke(context);
        }
        Object var13_18 = null;
        if (context.getStatus() == 2) return;
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        ActionMessage respMesg = context.getResponseMessage();
        debugTrace = Log.isDebug() && this.logger.hasTarget() ? new AmfTrace() : null;
        try {
            try {
                block39: {
                    long serializationOverhead = 0L;
                    if (context.isRecordMessageTimes()) {
                        context.getMPIO().sendTime = System.currentTimeMillis();
                        if (context.isRecordMessageSizes()) {
                            serializationOverhead = System.currentTimeMillis();
                        }
                    }
                    MessageSerializer serializer = sc2.newMessageSerializer();
                    serializer.initialize(sc2, outBuffer, debugTrace);
                    serializer.writeMessage(respMesg);
                    context.setSerializedBytes(outBuffer.size());
                    if (context.isRecordMessageSizes()) {
                        try {
                            context.getMPIO().messageSize = outBuffer.size();
                            if (context.isRecordMessageTimes()) {
                                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                context.getMPIO().addToOverhead(serializationOverhead);
                                context.getMPIO().sendTime = System.currentTimeMillis();
                            }
                            outBuffer = new ByteArrayOutputStream();
                            respMesg = context.getResponseMessage();
                            serializer.initialize(sc2, outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                        }
                        catch (Exception e10) {
                            if (!Log.isDebug()) break block39;
                            this.logger.debug("MPI set up error: " + e10.toString());
                        }
                    }
                }
                context.setResponseOutput(outBuffer);
            }
            catch (Exception e11) {
                SerializationFilter.handleSerializationException(sc2, context, e11, this.logger);
                Object var21_40 = null;
                if (debugTrace == null) return;
                this.logger.debug(debugTrace.toString());
                return;
            }
            Object var21_39 = null;
            if (debugTrace == null) return;
            this.logger.debug(debugTrace.toString());
            return;
        }
        catch (Throwable throwable) {
            Object var21_41 = null;
            if (debugTrace == null) throw throwable;
            this.logger.debug(debugTrace.toString());
            throw throwable;
        }
        {
            catch (Throwable t11) {
                this.unhandledError(context, t11);
                Object var13_19 = null;
                if (context.getStatus() == 2) return;
                outBuffer = new ByteArrayOutputStream();
                respMesg = context.getResponseMessage();
                debugTrace = Log.isDebug() && this.logger.hasTarget() ? new AmfTrace() : null;
                try {
                    try {
                        block40: {
                            long serializationOverhead = 0L;
                            if (context.isRecordMessageTimes()) {
                                context.getMPIO().sendTime = System.currentTimeMillis();
                                if (context.isRecordMessageSizes()) {
                                    serializationOverhead = System.currentTimeMillis();
                                }
                            }
                            MessageSerializer serializer = sc2.newMessageSerializer();
                            serializer.initialize(sc2, outBuffer, debugTrace);
                            serializer.writeMessage(respMesg);
                            context.setSerializedBytes(outBuffer.size());
                            if (context.isRecordMessageSizes()) {
                                try {
                                    context.getMPIO().messageSize = outBuffer.size();
                                    if (context.isRecordMessageTimes()) {
                                        serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                        context.getMPIO().addToOverhead(serializationOverhead);
                                        context.getMPIO().sendTime = System.currentTimeMillis();
                                    }
                                    outBuffer = new ByteArrayOutputStream();
                                    respMesg = context.getResponseMessage();
                                    serializer.initialize(sc2, outBuffer, debugTrace);
                                    serializer.writeMessage(respMesg);
                                }
                                catch (Exception e10) {
                                    if (!Log.isDebug()) break block40;
                                    this.logger.debug("MPI set up error: " + e10.toString());
                                }
                            }
                        }
                        context.setResponseOutput(outBuffer);
                    }
                    catch (Exception e11) {
                        SerializationFilter.handleSerializationException(sc2, context, e11, this.logger);
                        Object var21_43 = null;
                        if (debugTrace == null) return;
                        this.logger.debug(debugTrace.toString());
                        return;
                    }
                    Object var21_42 = null;
                    if (debugTrace == null) return;
                    this.logger.debug(debugTrace.toString());
                    return;
                }
                catch (Throwable throwable) {
                    Object var21_44 = null;
                    if (debugTrace == null) throw throwable;
                    this.logger.debug(debugTrace.toString());
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            if (context.getStatus() == 2) throw throwable;
            outBuffer = new ByteArrayOutputStream();
            respMesg = context.getResponseMessage();
            debugTrace = Log.isDebug() && this.logger.hasTarget() ? new AmfTrace() : null;
            try {
                try {
                    block41: {
                        long serializationOverhead = 0L;
                        if (context.isRecordMessageTimes()) {
                            context.getMPIO().sendTime = System.currentTimeMillis();
                            if (context.isRecordMessageSizes()) {
                                serializationOverhead = System.currentTimeMillis();
                            }
                        }
                        MessageSerializer serializer = sc2.newMessageSerializer();
                        serializer.initialize(sc2, outBuffer, debugTrace);
                        serializer.writeMessage(respMesg);
                        context.setSerializedBytes(outBuffer.size());
                        if (context.isRecordMessageSizes()) {
                            try {
                                context.getMPIO().messageSize = outBuffer.size();
                                if (context.isRecordMessageTimes()) {
                                    serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                    context.getMPIO().addToOverhead(serializationOverhead);
                                    context.getMPIO().sendTime = System.currentTimeMillis();
                                }
                                outBuffer = new ByteArrayOutputStream();
                                respMesg = context.getResponseMessage();
                                serializer.initialize(sc2, outBuffer, debugTrace);
                                serializer.writeMessage(respMesg);
                            }
                            catch (Exception e10) {
                                if (!Log.isDebug()) break block41;
                                this.logger.debug("MPI set up error: " + e10.toString());
                            }
                        }
                    }
                    context.setResponseOutput(outBuffer);
                }
                catch (Exception e11) {
                    SerializationFilter.handleSerializationException(sc2, context, e11, this.logger);
                    Object var21_46 = null;
                    if (debugTrace == null) throw throwable;
                    this.logger.debug(debugTrace.toString());
                    throw throwable;
                }
                Object var21_45 = null;
                if (debugTrace == null) throw throwable;
                this.logger.debug(debugTrace.toString());
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var21_47 = null;
                if (debugTrace == null) throw throwable2;
                this.logger.debug(debugTrace.toString());
                throw throwable2;
            }
        }
    }

    public static void handleDeserializationException(ActionContext actionContext, Throwable t10, Logger logger) throws IOException {
        if (t10 instanceof EOFException) {
            actionContext.setStatus(2);
        } else {
            String message;
            MessageException methodResult;
            if (t10 instanceof IOException) {
                if (Log.isDebug()) {
                    logger.debug("IOException reading message - client closed socket before sending the message?");
                }
                throw (IOException)t10;
            }
            actionContext.setStatus(1);
            MessageBody responseBody = new MessageBody();
            if (actionContext.getMessageNumber() < actionContext.getRequestMessage().getBodyCount()) {
                responseBody.setTargetURI(actionContext.getRequestMessageBody().getResponseURI());
            }
            if (actionContext.getVersion() == 0) {
                actionContext.setVersion(3);
            }
            actionContext.getResponseMessage().addBody(responseBody);
            if (t10 instanceof MessageException) {
                methodResult = (MessageException)t10;
                message = methodResult.getMessage();
            } else {
                methodResult = new SerializationException();
                methodResult.setMessage(10307);
                methodResult.setRootCause(t10);
                message = methodResult.getMessage();
            }
            responseBody.setData(methodResult.createErrorMessage());
            responseBody.setReplyMethod("/onStatus");
            if (Log.isError()) {
                logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString(t10));
            }
        }
    }

    public static void handleSerializationException(SerializationContext serializationContext, ActionContext actionContext, Throwable t10, Logger logger) {
        ActionMessage responseMessage = new ActionMessage();
        actionContext.setResponseMessage(responseMessage);
        int bodyCount = actionContext.getRequestMessage().getBodyCount();
        actionContext.setMessageNumber(0);
        while (actionContext.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(actionContext.getRequestMessageBody().getResponseURI());
            actionContext.getResponseMessage().addBody(responseBody);
            if (t10 instanceof MessageException) {
                methodResult = ((MessageException)t10).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t10.getMessage() != null && (message = t10.getMessage()) == null) {
                    message = t10.toString();
                }
                methodResult = new MessageException(message, t10).createErrorMessage();
            }
            if (actionContext.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put("message", error.faultString);
                    aso.put("code", error.faultCode);
                    aso.put("details", error.faultDetail);
                    aso.put("rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                try {
                    Message inMessage = actionContext.getRequestMessageBody().getDataAsMessage();
                    if (inMessage.getClientId() != null) {
                        ((AbstractMessage)methodResult).setClientId(inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        ((ErrorMessage)methodResult).setCorrelationId(inMessage.getMessageId());
                        ((ErrorMessage)methodResult).setDestination(inMessage.getDestination());
                    }
                }
                catch (MessageException ignore) {
                    // empty catch block
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            actionContext.incrementMessageNumber();
        }
        if (Log.isError() && logger != null) {
            logger.error("Exception occurred during serialization: " + ExceptionUtil.toString(t10));
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = Log.isDebug() && logger.hasTarget() ? new AmfTrace() : null;
        MessageSerializer serializer = serializationContext.newMessageSerializer();
        serializer.initialize(serializationContext, outBuffer, debugTrace);
        try {
            serializer.writeMessage(actionContext.getResponseMessage());
            actionContext.setResponseOutput(outBuffer);
        }
        catch (IOException e10) {
            MessageException ex2 = new MessageException();
            ex2.setMessage(10308);
            ex2.setRootCause(e10);
            throw ex2;
        }
    }

    private void unhandledError(ActionContext context, Throwable t10) {
        MessageException methodResult;
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t10 instanceof MessageException) {
            methodResult = (MessageException)t10;
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t10);
        }
        responseBody.setData(methodResult);
        responseBody.setReplyMethod("/onStatus");
        this.logger.info(t10.getMessage());
    }
}

