/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Stack;

public class LocalFileResolver
implements ConfigurationFileResolver {
    private Stack configurationPathStack = new Stack();
    int version = CLIENT;
    public static int CLIENT = 0;
    public static int SERVER = 1;
    public static int LIVECYCLE = 2;

    public LocalFileResolver() {
    }

    public LocalFileResolver(int version) {
        this.version = version;
    }

    public void setErrorMessage(ConfigurationException e10, String path) {
        if (this.version == LIVECYCLE) {
            e10.setMessage(11122, new Object[]{path});
        } else if (this.version == SERVER) {
            e10.setMessage(11108);
        } else {
            e10.setMessage(11106);
        }
    }

    public InputStream getConfigurationFile(String path) {
        File f10 = new File(path);
        try {
            if (f10 != null && f10.exists() && f10.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f10);
                this.pushConfigurationFile(f10.getParent());
                return fin;
            }
            ConfigurationException e10 = new ConfigurationException();
            this.setErrorMessage(e10, path);
            throw e10;
        }
        catch (FileNotFoundException ex2) {
            ConfigurationException e11 = new ConfigurationException();
            this.setErrorMessage(e11, path);
            e11.setRootCause(ex2);
            throw e11;
        }
        catch (SecurityException se2) {
            ConfigurationException e12 = new ConfigurationException();
            this.setErrorMessage(e12, path);
            e12.setRootCause(se2);
            throw e12;
        }
    }

    public InputStream getIncludedFile(String src2) {
        String path = this.configurationPathStack.peek() + File.separator + src2;
        File f10 = new File(path);
        try {
            if (f10 != null && f10.exists() && f10.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f10);
                this.pushConfigurationFile(f10.getParent());
                return fin;
            }
            ConfigurationException e10 = new ConfigurationException();
            e10.setMessage(11107, new Object[]{path});
            throw e10;
        }
        catch (FileNotFoundException ex2) {
            ConfigurationException e11 = new ConfigurationException();
            e11.setMessage(11107, new Object[]{path});
            e11.setRootCause(ex2);
            throw e11;
        }
        catch (SecurityException se2) {
            ConfigurationException e12 = new ConfigurationException();
            e12.setMessage(11107, new Object[]{path});
            e12.setRootCause(se2);
            throw e12;
        }
    }

    public void popIncludedFile() {
        this.configurationPathStack.pop();
    }

    private void pushConfigurationFile(String topLevelPath) {
        this.configurationPathStack.push(topLevelPath);
    }

    public String getIncludedPath(String src2) {
        return this.configurationPathStack.peek() + File.separator + src2;
    }

    public long getIncludedLastModified(String src2) {
        String path = this.configurationPathStack.peek() + File.separator + src2;
        File f10 = new File(path);
        return f10.lastModified();
    }
}

