/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigMap
extends LinkedHashMap {
    private static final long serialVersionUID = 8913604659150919550L;
    private static final int UNEXPECTED_MULTIPLE_VALUES = 10169;
    private static final String SYSPROPNAME_TRIM_CONFIG_PROPERTY_VALUES = "flex.trim-config-property-values";
    private static final boolean TRIM_CONFIG_PROPERTY_VALUES = Boolean.valueOf(System.getProperty("flex.trim-config-property-values", "true"));
    private HashSet accessedKeys = new HashSet();

    public ConfigMap() {
    }

    public ConfigMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConfigMap(ConfigMap m10) {
        this();
        this.addProperties(m10);
    }

    public void addProperties(ConfigMap p10) {
        for (Map.Entry entry : p10.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ValueList) {
                this.addProperties(key, (ValueList)value);
                continue;
            }
            this.addPropertyLogic(key, value);
        }
    }

    private void addProperties(Object key, ValueList values) {
        ValueList list = this.getValueList(key);
        if (list == null) {
            this.put(key, values.clone());
        } else {
            list.addAll(values);
        }
    }

    private void addPropertyLogic(Object key, Object value) {
        ValueList list = this.getValueList(key);
        if (list == null) {
            this.put(key, value);
        } else {
            list.add(value);
        }
    }

    private ValueList getValueList(Object key) {
        ValueList list;
        Object old = super.get(key);
        if (old instanceof ValueList) {
            list = (ValueList)old;
        } else if (old != null) {
            list = new ValueList();
            list.add(old);
            this.put(key, list);
        } else {
            list = null;
        }
        return list;
    }

    public void addProperty(String name, String value) {
        this.addPropertyLogic(name, TRIM_CONFIG_PROPERTY_VALUES && value != null ? value.trim() : value);
    }

    public void addProperty(String name, ConfigMap value) {
        this.addPropertyLogic(name, value);
    }

    public Set propertyNames() {
        return this.keySet();
    }

    public void allowProperty(String name) {
        this.accessedKeys.add(name);
    }

    public Object get(Object name) {
        this.accessedKeys.add(name);
        return super.get(name);
    }

    private Object getSinglePropertyOrFail(Object name) {
        Object result = this.get(name);
        if (result instanceof ValueList) {
            ConfigurationException exception = new ConfigurationException();
            exception.setMessage(10169, new Object[]{name});
            throw exception;
        }
        return result;
    }

    public String getProperty(String name) {
        return this.getPropertyAsString(name, null);
    }

    public ConfigMap getPropertyAsMap(String name, ConfigMap defaultValue) {
        Object prop = this.getSinglePropertyOrFail(name);
        if (prop instanceof ConfigMap) {
            return (ConfigMap)prop;
        }
        return defaultValue;
    }

    public String getPropertyAsString(String name, String defaultValue) {
        Object prop = this.getSinglePropertyOrFail(name);
        if (prop instanceof String) {
            return (String)prop;
        }
        return defaultValue;
    }

    public List getPropertyAsList(String name, List defaultValue) {
        Object prop = this.get(name);
        if (prop != null) {
            if (prop instanceof List) {
                return (List)prop;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(prop);
            return list;
        }
        return defaultValue;
    }

    public boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        Object prop = this.getSinglePropertyOrFail(name);
        if (prop instanceof String) {
            return Boolean.valueOf((String)prop);
        }
        return defaultValue;
    }

    public int getPropertyAsInt(String name, int defaultValue) {
        Object prop = this.getSinglePropertyOrFail(name);
        if (prop instanceof String) {
            try {
                return Integer.parseInt((String)prop);
            }
            catch (NumberFormatException ex2) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public long getPropertyAsLong(String name, long defaultValue) {
        Object prop = this.getSinglePropertyOrFail(name);
        if (prop instanceof String) {
            try {
                return Long.parseLong((String)prop);
            }
            catch (NumberFormatException ex2) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public List findAllUnusedProperties() {
        ArrayList result = new ArrayList();
        this.findUnusedProperties("", true, result);
        return result;
    }

    public void findUnusedProperties(String parentPath, boolean recurse, Collection result) {
        for (Map.Entry entry : this.entrySet()) {
            Object key = entry.getKey();
            String currentPath = parentPath + '/' + String.valueOf(key);
            if (!this.accessedKeys.contains(key)) {
                result.add(currentPath);
                continue;
            }
            if (!recurse) continue;
            Object value = entry.getValue();
            List values = value instanceof List ? (List)value : Collections.singletonList(value);
            for (int i10 = 0; i10 < values.size(); ++i10) {
                Object child = values.get(i10);
                if (!(child instanceof ConfigMap)) continue;
                ((ConfigMap)child).findUnusedProperties(currentPath, recurse, result);
            }
        }
    }

    private static class ValueList
    extends ArrayList {
        static final long serialVersionUID = -5637755312744414675L;

        private ValueList() {
        }
    }
}

