/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import flex.messaging.FlexContext;
import flex.messaging.cluster.BroadcastHandler;
import flex.messaging.cluster.Cluster;
import flex.messaging.cluster.ClusterException;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.cluster.ClusterMembershipListener;
import flex.messaging.cluster.ClusterNode;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.services.Service;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsCluster
extends Cluster
implements RequestHandler {
    public static final String PROPERTY_CHANNEL_BLOCK = "channel-block";
    public static final String PROPERTY_CHANNEL_AUTO_GETSTATE = "channel-auto-getstate";
    public static final String PROPERTY_CHANNEL_AUTO_RECONNECT = "channel-auto-reconnect";
    public static final String PROPERTY_CHANNEL_LOCAL = "channel-local";
    private MessageDispatcher broadcastDispatcher;
    private final List<BroadcastHandler> broadcastHandlers;
    private String clusterId;
    private JChannel clusterChannel;
    private final ClusterManager clusterManager;
    private final ClusterMembershipListener clusterMembershipListener;
    private final Map<Address, ClusterNode> clusterNodes;

    public JGroupsCluster(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        this.broadcastHandlers = new ArrayList<BroadcastHandler>();
        this.clusterMembershipListener = new ClusterMembershipListener(this);
        this.clusterNodes = new HashMap<Address, ClusterNode>();
        this.configureBroadcastHandlers();
    }

    @Override
    public void initialize(String id2, ConfigMap properties) {
        this.clusterId = id2;
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Joining cluster with id: " + this.clusterId);
        }
        boolean channelAutoGetState = false;
        boolean channelAutoReconnect = false;
        boolean channelBlock = false;
        boolean channelLocal = false;
        if (properties != null && !properties.isEmpty()) {
            channelAutoGetState = properties.getPropertyAsBoolean(PROPERTY_CHANNEL_AUTO_GETSTATE, false);
            channelAutoReconnect = properties.getPropertyAsBoolean(PROPERTY_CHANNEL_AUTO_RECONNECT, false);
            channelBlock = properties.getPropertyAsBoolean(PROPERTY_CHANNEL_BLOCK, false);
            channelLocal = properties.getPropertyAsBoolean(PROPERTY_CHANNEL_LOCAL, false);
        }
        try {
            JChannelFactory channelFactory = new JChannelFactory(this.clusterPropertiesFile);
            this.clusterChannel = (JChannel)channelFactory.createChannel();
            this.clusterChannel.setOpt(6, (Object)channelAutoGetState);
            this.clusterChannel.setOpt(5, (Object)channelAutoReconnect);
            this.clusterChannel.setOpt(0, (Object)channelBlock);
            this.clusterChannel.setOpt(3, (Object)channelLocal);
            this.broadcastDispatcher = new MessageDispatcher((Channel)this.clusterChannel, null, (MembershipListener)this.clusterMembershipListener, (RequestHandler)this);
            this.clusterChannel.connect(this.clusterId);
        }
        catch (ChannelException cex) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10200, new Object[]{this.clusterId, this.clusterPropertiesFile});
            cx2.setRootCause(cex);
            throw cx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, String>> getAllEndpoints(String serviceType, String destName) {
        ArrayList<Map<String, String>> channelToEndpointMaps = new ArrayList<Map<String, String>>();
        Map<Address, ClusterNode> map = this.clusterNodes;
        synchronized (map) {
            for (Map.Entry<Address, ClusterNode> clusterNodeEntry : this.clusterNodes.entrySet()) {
                ClusterNode node;
                Map<String, String> nodeEndpoints;
                Address addr = clusterNodeEntry.getKey();
                if (this.clusterMembershipListener.isZombie(addr) || (nodeEndpoints = (node = this.clusterNodes.get(addr)).getEndpoints(serviceType, destName)).isEmpty()) continue;
                for (Map map2 : channelToEndpointMaps) {
                    for (String endpointUrl : map2.values()) {
                        if (!nodeEndpoints.containsValue(endpointUrl)) continue;
                        Iterator<String> iter3 = nodeEndpoints.values().iterator();
                        while (iter3.hasNext()) {
                            String endpointUrl2 = iter3.next();
                            if (!endpointUrl2.equals(endpointUrl)) continue;
                            iter3.remove();
                        }
                    }
                }
                if (nodeEndpoints.size() <= 0) continue;
                channelToEndpointMaps.add(nodeEndpoints);
            }
        }
        return channelToEndpointMaps;
    }

    @Override
    public void destroy() {
        try {
            this.clusterChannel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void configureBroadcastHandlers() {
        this.broadcastHandlers.add(new ServiceOperationHandler(this));
        this.broadcastHandlers.add(new RemoteEndpointHandler(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClusterNode(Address address) {
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Cluster node from address " + address + " joined the cluster for " + this.clusterId);
        }
        ClusterNode remoteNode = null;
        Map<Address, ClusterNode> map = this.clusterNodes;
        synchronized (map) {
            remoteNode = this.clusterNodes.get(address);
        }
        if (remoteNode == null) {
            this.broadcastMyEndpoints(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClusterNode(Address address) {
        Map<Address, ClusterNode> map = this.clusterNodes;
        synchronized (map) {
            this.clusterNodes.remove(address);
        }
        this.sendRemoveNodeListener(address);
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Cluster node from address " + address + " abandoned the cluster for " + this.clusterId);
        }
    }

    Address getJGroupsLocalAddress() {
        return this.clusterChannel.getLocalAddress();
    }

    @Override
    public Object getLocalAddress() {
        return this.getJGroupsLocalAddress();
    }

    @Override
    public void addLocalEndpointForChannel(String serviceType, String destName, String channelId, String endpointUrl, int endpointPort) {
        if (Log.isDebug()) {
            Log.getLogger("Service.Cluster").debug("Adding local clustered destination endpoint and broadcasting to peers. cluster-id=" + this.clusterId + " destination=" + destName + " channelId=" + channelId + " endpoint url=" + endpointUrl + " endpointPort=" + endpointPort);
        }
        Address myAddr = this.getJGroupsLocalAddress();
        ClusterNode myNode = this.getNodeForAddress(myAddr);
        endpointUrl = this.canonicalizeUrl(channelId, endpointUrl, endpointPort, myNode);
        myNode.addEndpoint(serviceType, destName, channelId, endpointUrl);
        this.broadcastClusterOperation("addEndpointForChannel", serviceType, destName, channelId, endpointUrl, null);
    }

    void addEndpointForChannel(Address address, String serviceType, String destName, String channelId, String endpointUrl) {
        ClusterNode node = this.getNodeForAddress(address);
        if (!node.containsEndpoint(serviceType, destName, channelId, endpointUrl)) {
            if (Log.isDebug()) {
                Log.getLogger("Service.Cluster").debug("Adding remote clustered destination endpoint from address " + address + ". cluster-id=" + this.clusterId + " destination=" + destName + " channelId=" + channelId + " endpoint url=" + endpointUrl);
            }
            node.addEndpoint(serviceType, destName, channelId, endpointUrl);
            this.broadcastMyEndpoints(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastMyEndpoints(Address address) {
        Map<String, Map<String, String>> destKeyToChannelMap;
        Vector<Address> destination = new Vector<Address>();
        destination.add(address);
        ClusterNode myNode = this.getNodeForAddress(this.clusterChannel.getLocalAddress());
        Map<String, Map<String, String>> map = destKeyToChannelMap = myNode.getDestKeyToChannelMap();
        synchronized (map) {
            for (Map.Entry<String, Map<String, String>> entry : destKeyToChannelMap.entrySet()) {
                String destKey = entry.getKey();
                int ix2 = destKey.indexOf(":");
                String serviceType = destKey.substring(0, ix2);
                String destName = destKey.substring(ix2 + 1);
                Map<String, String> channelEndpoints = myNode.getEndpoints(serviceType, destName);
                for (Map.Entry<String, String> channelEndpointEntry : channelEndpoints.entrySet()) {
                    this.broadcastClusterOperation("addEndpointForChannel", serviceType, destName, channelEndpointEntry.getKey(), channelEndpointEntry.getValue(), destination);
                }
            }
        }
    }

    void broadcastClusterOperation(String clusterOperation, String serviceType, String destName, String channelId, String endpointUrl, Vector<Address> destinations) {
        ArrayList<Object> operationInfo = new ArrayList<Object>();
        operationInfo.add(serviceType);
        operationInfo.add(destName);
        operationInfo.add(channelId);
        operationInfo.add(endpointUrl);
        this.broadcastOperation(clusterOperation, operationInfo, destinations);
    }

    @Override
    public void broadcastServiceOperation(String serviceOperation, Object[] params) {
        ArrayList<Object> operationInfo = new ArrayList<Object>();
        operationInfo.addAll(Arrays.asList(params));
        this.broadcastOperation(serviceOperation, operationInfo, null);
    }

    @Override
    public void sendPointToPointServiceOperation(String serviceOperation, Object[] params, Object targetAddress) {
        ArrayList<Object> operationInfo = new ArrayList<Object>();
        operationInfo.addAll(Arrays.asList(params));
        operationInfo.add(this.getJGroupsLocalAddress());
        Vector<Address> targetDestination = new Vector<Address>();
        if (targetAddress != null) {
            targetDestination.add((Address)targetAddress);
        } else {
            for (int i10 = 0; i10 < this.clusterChannel.getView().getMembers().size(); ++i10) {
                Address a10 = (Address)this.clusterChannel.getView().getMembers().get(i10);
                if (a10.equals(this.getJGroupsLocalAddress())) continue;
                targetDestination.add(a10);
                break;
            }
        }
        this.broadcastOperation(serviceOperation, operationInfo, targetDestination);
    }

    @Override
    public List<Address> getMemberAddresses() {
        return this.clusterChannel.getView().getMembers();
    }

    private void broadcastOperation(String operationName, List<Object> operationParams, Vector<Address> destinations) {
        try {
            operationParams.add(0, operationName);
            Message operationMessage = new Message(null, this.getJGroupsLocalAddress(), (Serializable)((Object)operationParams));
            this.broadcastDispatcher.castMessage(destinations, operationMessage, 6, 0L);
        }
        catch (IllegalArgumentException iae) {
            String message = iae.getMessage();
            String notSerializableType = null;
            if (message != null && message.startsWith("java.io.NotSerializableException")) {
                notSerializableType = message.substring(message.indexOf(": ") + 2);
            }
            if (notSerializableType != null) {
                ClusterException cx2 = new ClusterException();
                cx2.setMessage(10212, new Object[]{this.clusterId, notSerializableType});
                cx2.setRootCause(iae);
                throw cx2;
            }
            ClusterException cx3 = new ClusterException();
            cx3.setMessage(10204, new Object[]{this.clusterId});
            cx3.setRootCause(iae);
            throw cx3;
        }
        catch (Exception e10) {
            ClusterException cx4 = new ClusterException();
            cx4.setMessage(10204, new Object[]{this.clusterId});
            cx4.setRootCause(e10);
            throw cx4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(Message msg) {
        if (msg.getSrc() != this.getJGroupsLocalAddress()) {
            List operationInfo = (List)msg.getObject();
            String operationName = (String)operationInfo.get(0);
            try {
                FlexContext.setThreadLocalObjects(null, null, this.clusterManager.getMessageBroker(), null, null, null);
                boolean handled = false;
                for (BroadcastHandler handler : this.broadcastHandlers) {
                    if (!handler.isSupportedOperation(operationName)) continue;
                    handler.handleBroadcast(msg.getSrc(), operationInfo);
                    handled = true;
                    break;
                }
                if (!handled && Log.isWarn()) {
                    Log.getLogger("Service.Cluster").warn("Cluster message was not handled by any registered handler. Unhandled message info: " + operationInfo);
                }
            }
            finally {
                FlexContext.clearThreadLocalObjects();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterNode getNodeForAddress(Address addr) {
        Map<Address, ClusterNode> map = this.clusterNodes;
        synchronized (map) {
            ClusterNode node = this.clusterNodes.get(addr);
            if (node == null) {
                node = new ClusterNode(addr);
                this.clusterNodes.put(addr, node);
            }
            return node;
        }
    }

    private String canonicalizeUrl(String channelId, String endpointUrl, int endpointPort, ClusterNode myNode) {
        if (endpointUrl.startsWith("/")) {
            ClusterException cx2 = new ClusterException();
            cx2.setMessage(10203, new Object[]{channelId});
            throw cx2;
        }
        if (endpointUrl.indexOf(":///") != -1) {
            endpointUrl = StringUtils.substitute(endpointUrl, ":///", "://" + myNode.getHost() + "/");
        }
        if (endpointPort != 0 && endpointUrl.indexOf("" + endpointPort) == -1) {
            StringBuffer sb2 = new StringBuffer(endpointUrl);
            sb2.insert(endpointUrl.indexOf("/", endpointUrl.indexOf("://") + 3), ":" + endpointPort);
            endpointUrl = sb2.toString();
        }
        return endpointUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceOperationHandler
    implements BroadcastHandler {
        static final HashMap<String, Boolean> supportedOperations = new HashMap();
        private final JGroupsCluster cluster;

        public ServiceOperationHandler(JGroupsCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public void handleBroadcast(Object sender, List<Object> params) {
            block6: {
                try {
                    String serviceType = (String)params.get(1);
                    Service svc2 = this.cluster.clusterManager.getMessageBroker().getServiceByType(serviceType);
                    if (svc2 == null) break block6;
                    String methodName = (String)params.get(0);
                    Object[] paramValues = params.subList(3, params.size()).toArray();
                    Method[] svcMethods = svc2.getClass().getMethods();
                    for (int i10 = 0; i10 < svcMethods.length; ++i10) {
                        if (!svcMethods[i10].getName().equals(methodName)) continue;
                        svcMethods[i10].invoke((Object)svc2, paramValues);
                        break;
                    }
                }
                catch (InvocationTargetException ite) {
                    Throwable th2 = ite.getCause();
                    if (Log.isError()) {
                        Log.getLogger("Service.Cluster").error("Error handling message pushed from cluster: " + th2 + StringUtils.NEWLINE + "Exception=" + ExceptionUtil.toString(th2));
                    }
                    ClusterException cx2 = new ClusterException();
                    cx2.setMessage(10205, new Object[]{this.cluster.clusterId});
                    cx2.setRootCause(th2);
                    throw cx2;
                }
                catch (Exception e10) {
                    if (Log.isError()) {
                        Log.getLogger("Service.Cluster").error("Error handling message pushed from cluster: " + e10 + StringUtils.NEWLINE + "Exception=" + ExceptionUtil.toString(e10));
                    }
                    ClusterException cx3 = new ClusterException();
                    cx3.setMessage(10205, new Object[]{this.cluster.clusterId});
                    cx3.setRootCause(e10);
                    throw cx3;
                }
            }
        }

        @Override
        public boolean isSupportedOperation(String name) {
            return supportedOperations.containsKey(name);
        }

        static {
            supportedOperations.put("pushMessageFromPeer", Boolean.TRUE);
            supportedOperations.put("peerSyncAndPush", Boolean.TRUE);
            supportedOperations.put("requestAdapterState", Boolean.TRUE);
            supportedOperations.put("receiveAdapterState", Boolean.TRUE);
            supportedOperations.put("sendSubscriptions", Boolean.TRUE);
            supportedOperations.put("receiveSubscriptions", Boolean.TRUE);
            supportedOperations.put("subscribeFromPeer", Boolean.TRUE);
            supportedOperations.put("pushMessageFromPeerToPeer", Boolean.TRUE);
            supportedOperations.put("peerSyncAndPushOneToPeer", Boolean.TRUE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RemoteEndpointHandler
    implements BroadcastHandler {
        static final HashMap<String, Boolean> supportedOperations = new HashMap();
        private final JGroupsCluster cluster;

        public RemoteEndpointHandler(JGroupsCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public void handleBroadcast(Object sender, List<Object> params) {
            block9: {
                String opName = (String)params.get(0);
                if (opName.equals("addEndpointForChannel")) {
                    this.cluster.addEndpointForChannel((Address)sender, (String)params.get(1), (String)params.get(2), (String)params.get(3), (String)params.get(4));
                    return;
                }
                String endpointId = (String)params.get(1);
                Endpoint endpoint = this.cluster.clusterManager.getMessageBroker().getEndpoint(endpointId);
                try {
                    if (endpoint != null) {
                        Object[] paramValues = params.subList(3, params.size()).toArray();
                        Method[] endpointMethods = endpoint.getClass().getMethods();
                        for (int i10 = 0; i10 < endpointMethods.length; ++i10) {
                            if (!endpointMethods[i10].getName().equals(opName)) continue;
                            endpointMethods[i10].invoke((Object)endpoint, paramValues);
                            break block9;
                        }
                        break block9;
                    }
                    if (Log.isWarn()) {
                        Log.getLogger("Service.Cluster").warn("Cluster message targeting endpoint '" + endpointId + "' will be ignored because no endpoint is registered under that id.");
                    }
                }
                catch (InvocationTargetException ite) {
                    Throwable th2 = ite.getCause();
                    if (Log.isError()) {
                        Log.getLogger("Service.Cluster").error("Error handling cluster message targetting endpoint '" + endpointId + "' and operation '" + opName + "'.", th2);
                    }
                    ClusterException cx2 = new ClusterException();
                    cx2.setMessage(10219, new Object[]{this.cluster.clusterId});
                    cx2.setRootCause(th2);
                    throw cx2;
                }
                catch (Exception e10) {
                    if (Log.isError()) {
                        Log.getLogger("Service.Cluster").error("Error handling cluster message targetting endpoint '" + endpointId + "' and operation '" + opName + "'.", e10);
                    }
                    ClusterException cx3 = new ClusterException();
                    cx3.setMessage(10219, new Object[]{this.cluster.clusterId});
                    cx3.setRootCause(e10);
                    throw cx3;
                }
            }
        }

        @Override
        public boolean isSupportedOperation(String name) {
            return supportedOperations.containsKey(name);
        }

        static {
            supportedOperations.put("addEndpointForChannel", Boolean.TRUE);
            supportedOperations.put("sendEndpointUrl", Boolean.TRUE);
            supportedOperations.put("receiveEndpointUrl", Boolean.TRUE);
        }
    }
}

