/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterNode {
    private final String host;
    private final Map<String, Map<String, String>> destKeyToChannelMap;

    ClusterNode(Address address) {
        IpAddress addr = (IpAddress)address;
        this.host = addr.getIpAddress().getCanonicalHostName();
        this.destKeyToChannelMap = new HashMap<String, Map<String, String>>();
    }

    String getHost() {
        return this.host;
    }

    Map<String, Map<String, String>> getDestKeyToChannelMap() {
        return this.destKeyToChannelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getEndpoints(String serviceType, String destName) {
        String destKey = serviceType + ":" + destName;
        Map<String, Map<String, String>> map = this.destKeyToChannelMap;
        synchronized (map) {
            Map<String, String> channelEndpoints = this.destKeyToChannelMap.get(destKey);
            if (channelEndpoints == null) {
                channelEndpoints = new HashMap<String, String>();
                this.destKeyToChannelMap.put(destKey, channelEndpoints);
            }
            return channelEndpoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEndpoint(String serviceType, String destName, String channelId, String endpointUrl) {
        Map<String, Map<String, String>> map = this.destKeyToChannelMap;
        synchronized (map) {
            Map<String, String> channelEndpoints = this.getEndpoints(serviceType, destName);
            channelEndpoints.put(channelId, endpointUrl);
        }
    }

    boolean containsEndpoint(String serviceType, String destName, String channelId, String endpointUrl) {
        Map<String, String> channelEndpoints = this.getEndpoints(serviceType, destName);
        return channelEndpoints.containsKey(channelId) && channelEndpoints.get(channelId).equals(endpointUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb2 = new StringBuffer("ClusterNode[");
        Map<String, Map<String, String>> map = this.destKeyToChannelMap;
        synchronized (map) {
            for (Map.Entry<String, Map<String, String>> entry : this.destKeyToChannelMap.entrySet()) {
                sb2.append(" channels for ");
                sb2.append(entry.getKey());
                sb2.append('(');
                Iterator<Map.Entry<String, String>> iter = entry.getValue().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, String> channelMapEntry = iter.next();
                    sb2.append(channelMapEntry.getKey());
                    sb2.append('=');
                    sb2.append(channelMapEntry.getValue());
                    if (!iter.hasNext()) continue;
                    sb2.append(", ");
                }
                sb2.append(')');
            }
        }
        sb2.append(" ]");
        return sb2.toString();
    }
}

