/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging;

import flex.management.BaseControl;
import flex.management.runtime.AdminConsoleDisplayRegistrar;
import flex.management.runtime.messaging.MessageBrokerControlMBean;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.AMFEndpoint;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.endpoints.HTTPEndpoint;
import flex.messaging.endpoints.StreamingAMFEndpoint;
import flex.messaging.endpoints.StreamingHTTPEndpoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.ObjectName;

public class MessageBrokerControl
extends BaseControl
implements MessageBrokerControlMBean {
    private static final Object classMutex = new Object();
    private static final String TYPE = "MessageBroker";
    private static int instanceCount = 0;
    private String id;
    private MessageBroker broker;
    private List endpointNames;
    private List amfEndpoints;
    private List httpEndpoints;
    private List enterpriseEndpoints;
    private List streamingAmfEndpoints;
    private List streamingHttpEndpoints;
    private List services;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBrokerControl(MessageBroker broker) {
        super(null);
        this.broker = broker;
        this.endpointNames = new ArrayList();
        this.amfEndpoints = new ArrayList();
        this.httpEndpoints = new ArrayList();
        this.enterpriseEndpoints = new ArrayList();
        this.streamingAmfEndpoints = new ArrayList();
        this.streamingHttpEndpoints = new ArrayList();
        this.services = new ArrayList();
        Object object = classMutex;
        synchronized (object) {
            this.id = TYPE + ++instanceCount;
        }
        this.setRegistrar(new AdminConsoleDisplayRegistrar(this));
    }

    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        this.getRegistrar().registerObject(2, name, "FlexSessionCount");
        this.getRegistrar().registerObjects(new int[]{2, 50}, name, new String[]{"AMFThroughput", "HTTPThroughput", "EnterpriseThroughput"});
        this.getRegistrar().registerObject(1, name, "MaxFlexSessionsInCurrentHour");
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return TYPE;
    }

    public Boolean isRunning() {
        return this.broker.isStarted();
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public ObjectName[] getEndpoints() throws IOException {
        int size = this.endpointNames.size();
        ObjectName[] endpointNameObjects = new ObjectName[size];
        for (int i10 = 0; i10 < size; ++i10) {
            endpointNameObjects[i10] = (ObjectName)this.endpointNames.get(i10);
        }
        return endpointNameObjects;
    }

    public void addEndpoint(Endpoint value) {
        if (value instanceof AMFEndpoint) {
            this.amfEndpoints.add(value);
        } else if (value instanceof HTTPEndpoint) {
            this.httpEndpoints.add(value);
        } else if (value instanceof StreamingAMFEndpoint) {
            this.streamingAmfEndpoints.add(value);
        } else if (value instanceof StreamingHTTPEndpoint) {
            this.streamingHttpEndpoints.add(value);
        } else {
            this.enterpriseEndpoints.add(value);
        }
        this.endpointNames.add(value.getControl().getObjectName());
    }

    public void removeEndpoint(ObjectName value) {
        this.endpointNames.remove(value);
    }

    public ObjectName[] getServices() throws IOException {
        int size = this.services.size();
        ObjectName[] serviceNames = new ObjectName[size];
        for (int i10 = 0; i10 < size; ++i10) {
            serviceNames[i10] = (ObjectName)this.services.get(i10);
        }
        return serviceNames;
    }

    public void addService(ObjectName value) {
        this.services.add(value);
    }

    public void removeService(ObjectName value) {
        this.services.remove(value);
    }

    public Integer getFlexSessionCount() {
        return this.broker.getFlexSessionManager().getFlexSessionCount();
    }

    public Integer getMaxFlexSessionsInCurrentHour() {
        return this.broker.getFlexSessionManager().getMaxFlexSessionsInCurrentHour();
    }

    public Integer getEnterpriseConnectionCount() throws IOException {
        int connections = 0;
        return new Integer(connections);
    }

    public Long getAMFThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.amfEndpoints));
    }

    public Long getHTTPThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.httpEndpoints));
    }

    public Long getEnterpriseThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.enterpriseEndpoints));
    }

    public Long getStreamingAMFThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.streamingAmfEndpoints));
    }

    public Long getStreamingHTTPThroughput() throws IOException {
        return new Long(this.calculateEndpointThroughput(this.streamingHttpEndpoints));
    }

    private long calculateEndpointThroughput(List endpoints) {
        long throughput = 0L;
        for (int i10 = 0; i10 < endpoints.size(); ++i10) {
            if (!(endpoints.get(i10) instanceof AbstractEndpoint)) continue;
            throughput += ((AbstractEndpoint)endpoints.get(i10)).getThroughput();
        }
        return throughput;
    }
}

