//
// TParams.cpp
//
// Defines all the construction parameters for a terrain.
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#include "vtlib/vtlib.h"
#include <string.h>
#include "TParams.h"

#include <fstream>
using namespace std;

// default (currently fixed) number of tiles
#define NTILES	4

TParams::TParams()
{
	// provide some defaults
	m_fVerticalExag = 1.0f;
	m_bRegular = false;
	m_bDynamic = false;
	m_iTriCount = 10000;
	m_fPixelError = 2.0f;
	m_fTimeSpeed = 1;
}

//
// copy constructor
//
TParams::TParams(const TParams &paramsSrc)
{
	*this = paramsSrc;
}

//
// assignment operator
//
const TParams &TParams::operator = (const TParams &rhs)
{
	m_strName = rhs.m_strName;
	m_strElevFile = rhs.m_strElevFile;
	m_fVerticalExag = rhs.m_fVerticalExag;
	m_iMinHeight = rhs.m_iMinHeight;
	m_fNavSpeed = rhs.m_fNavSpeed;
	m_strLocFile = rhs.m_strLocFile;

	m_bRegular = rhs.m_bRegular;
	m_iSubsample = rhs.m_iSubsample;

	m_bDynamic = rhs.m_bDynamic;
	m_eLodMethod = rhs.m_eLodMethod;
	m_fPixelError = rhs.m_fPixelError;
	m_iTriCount = rhs.m_iTriCount;
	m_bTriStrips = rhs.m_bTriStrips;
	m_bDetailTexture = rhs.m_bDetailTexture;

	m_bTimeOn = rhs.m_bTimeOn;
	m_iInitTime = rhs.m_iInitTime;
	m_fTimeSpeed = rhs.m_fTimeSpeed;

	m_eTexture = rhs.m_eTexture;
	m_iTilesize = rhs.m_iTilesize;
	m_strTextureSingle = rhs.m_strTextureSingle;
	m_strTextureBase = rhs.m_strTextureBase;
	m_strTextureFilename = rhs.m_strTextureFilename;
	m_bMipmap = rhs.m_bMipmap;
	m_b16bit = rhs.m_b16bit;

	m_bRoads = rhs.m_bRoads;
	m_strRoadFile = rhs.m_strRoadFile;
	m_bHwy = rhs.m_bHwy;
	m_bPaved = rhs.m_bPaved;
	m_bDirt = rhs.m_bDirt;
	m_fRoadHeight = rhs.m_fRoadHeight;
	m_fRoadDistance = rhs.m_fRoadDistance;
	m_bTexRoads = rhs.m_bTexRoads;
	m_bRoadCulture = rhs.m_bRoadCulture;

	m_bTrees = rhs.m_bTrees;
	m_strTreeFile = rhs.m_strTreeFile;
	m_iTreeDistance = rhs.m_iTreeDistance;
	m_bAgriculture = rhs.m_bAgriculture;
	m_bWildVeg = rhs.m_bWildVeg;

	m_bDoMotion = rhs.m_bDoMotion;
	m_strMotionScript = rhs.m_strMotionScript;

	m_bFog = rhs.m_bFog;
	m_iFogDistance = rhs.m_iFogDistance;

	m_bBuildings = rhs.m_bBuildings;
	m_strBuildingFile = rhs.m_strBuildingFile;

	m_bVehicles = rhs.m_bVehicles;
	m_fVehicleSize = rhs.m_fVehicleSize;
	m_fVehicleSpeed = rhs.m_fVehicleSpeed;
	m_iNumCars = rhs.m_iNumCars;

	m_bSky = rhs.m_bSky;
	m_bOceanPlane = rhs.m_bOceanPlane;
	m_bHorizon = rhs.m_bHorizon;
	m_bVertexColors = rhs.m_bVertexColors;
	m_bOverlay = rhs.m_bOverlay;
	m_bSuppressLand = rhs.m_bSuppressLand;
	m_bLabels = rhs.m_bLabels;

	m_bFences = rhs.m_bFences;
	m_strFenceFile = rhs.m_strFenceFile;

	m_bPreLight = rhs.m_bPreLight;
	m_bPreLit = rhs.m_bPreLit;
	m_fPreLightFactor = rhs.m_fPreLightFactor;

	m_bAirports = rhs.m_bAirports;

	return *this;
}

//
// helper
//
vtString get_line_from_stream(ifstream &input)
{
	char buf[80];
	input.getline(buf, 80);
	int len = strlen(buf);

	// trim trailing CR and LF characters
	while (len > 0 && (buf[len-1] == '\r' || buf[len-1] == '\n'))
	{
		buf[len-1] = '\0';
		len--;
	}
	return vtString(buf);
}

/* alternate version
vtString get_line_from_stream(ifstream &input)
{
	char buf[80];
	// eat leading LF
	if (input.peek() == '\n') {
		input.ignore();
		buf[0] = '\0';
	} else {
		input >> buf;
	}

	return vtString(buf);
}
*/

#define STR_NAME "Name"
#define STR_ELEVFILE "Filename"
#define STR_LOCFILENAME "Locations_File"
#define STR_VERTICALEXAG "Vertical_Exag"
#define STR_MINHEIGHT "Min_Height"
#define STR_NAVSPEED "Nav_Speed"
#define STR_LOCFILE "Locations_File"

#define STR_REGULAR "Regular"
#define STR_SUBSAMPLE "Subsample"
#define STR_DYNAMIC "Dynamic"
#define STR_LODMETHOD "LOD_Method"
#define STR_PIXELERROR "Pixel_Error"
#define STR_TRICOUNT "Tri_Count"
#define STR_TIMEON "Time_On"
#define STR_INITTIME "Init_Time"
#define STR_TIMESPEED "Time_Speed"
#define STR_SKY "Sky"
#define STR_FOG "Fog"
#define STR_TEXTURE "Texture"
#define STR_NTILES "Num_Tiles"
#define STR_TILESIZE "Tile_Size"
#define STR_TEXTURESINGLE "Single_Texture"
#define STR_TEXTUREBASE "Base_Texture"
#define STR_MIPMAP "MIP_Map"
#define STR_16BIT "16_Bit"
#define STR_PRELIGHT "Pre-Light"
#define STR_PRELIT "Pre-Lit"
#define STR_ROADS "Roads"
#define STR_ROADFILE "Road_File"
#define STR_HWY "Highway"
#define STR_PAVED "Paved"
#define STR_DIRT "Dirt"
#define STR_ROADHEIGHT "Road_Height"
#define STR_ROADDISTANCE "Road_Distance"
#define STR_TEXROADS "Road_Texture"
#define STR_ROADCULTURE "Road_Culture"
#define STR_FENCES "Fences"
#define STR_FENCEFILE "Fence_File"
#define STR_TREES "Trees"
#define STR_TREEFILE "Tree_File"
#define STR_TREEDISTANCE "Tree_Distance"
#define STR_FOGDISTANCE "Fog_Distance"
#define STR_DOMOTION "Do_Motion"
#define STR_MOTIONSCRIPT "Motion_Script"
#define STR_VERTEXCOLORS "Vertex_Colors"
#define STR_OVERLAY	"Overlay"
#define STR_SUPPRESSLAND "Suppress_Land"
#define STR_OCEANPLANE "Ocean_Plane"
#define STR_HORIZON "Horizon"
#define STR_LABELS "Labels"
#define STR_BUILDINGS "Buildings"
#define STR_BUILDINGFILE "Building_File"
#define STR_VEHICLES "Vehicles"
#define STR_VEHICLESIZE "Vehicle_Size"
#define STR_VEHICLESPEED "Vehicle_Speed"
#define STR_NUMCARS "Number_of_Cars"
#define STR_AGRICULTURE "Agriculture"
#define STR_WILDVEG	"Wild_Vegetation"
#define STR_TRISTRIPS "Tristrips"
#define STR_DETAILTEXTURE "Detail_Texture"
#define STR_PRELIGHTFACTOR "PreLight_Factor"
#define STR_AIRPORTS "Airports"

bool TParams::LoadFromFile(const char *filename)
{
	int iDummy;

//	ifstream input(filename, ios::nocreate | ios::binary);
//	ifstream input(filename, ios::binary);
//	ifstream input(filename, ios_base::in | ios_base::binary);
	ifstream input(filename, ios::in | ios::binary);
	if (!input.is_open())
		return false;

	// read from file
	char buf[80];

	while (!input.eof())
	{
		if (input.peek() == '\n')
			input.ignore();
		input >> buf;

		// data value should been separated by a tab or space
		int next = input.peek();
		if (next != '\t' && next != ' ')
			continue;
		while (input.peek() == '\t' || input.peek() == ' ')
			input.ignore();

		if (strcmp(buf, STR_NAME) == 0)
			m_strName = get_line_from_stream(input);
		else if (strcmp(buf, STR_ELEVFILE) == 0)
			m_strElevFile = get_line_from_stream(input);
		else if (strcmp(buf, STR_LOCFILENAME) == 0)
			m_strLocFile = get_line_from_stream(input);
		else if (strcmp(buf, STR_VERTICALEXAG) == 0)
			input >> m_fVerticalExag;
		else if (strcmp(buf, STR_MINHEIGHT) == 0)
			input >> m_iMinHeight;
		else if (strcmp(buf, STR_NAVSPEED) == 0)
			input >> m_fNavSpeed;
		else if (strcmp(buf, STR_REGULAR) == 0)
			input >> m_bRegular;
		else if (strcmp(buf, STR_SUBSAMPLE) == 0)
			input >> m_iSubsample;
		else if (strcmp(buf, STR_DYNAMIC) == 0)
			input >> m_bDynamic;
		else if (strcmp(buf, STR_LODMETHOD) == 0)
		{
			int dummy;
			input >> dummy;
			m_eLodMethod = (enum LodMethodEnum)dummy;
		}
		else if (strcmp(buf, STR_PIXELERROR) == 0)
			input >> m_fPixelError;
		else if (strcmp(buf, STR_TRICOUNT) == 0)
			input >> m_iTriCount;
		else if (strcmp(buf, STR_TIMEON) == 0)
			input >> m_bTimeOn;
		else if (strcmp(buf, STR_INITTIME) == 0)
			input >> m_iInitTime;
		else if (strcmp(buf, STR_TIMESPEED) == 0)
			input >> m_fTimeSpeed;
		else if (strcmp(buf, STR_SKY) == 0)
			input >> m_bSky;
		else if (strcmp(buf, STR_FOG) == 0)
			input >> m_bFog;
		else if (strcmp(buf, STR_TEXTURE) == 0)
		{
			int dummy;
			input >> dummy;
			m_eTexture = (enum TextureEnum)dummy;
		}
		else if (strcmp(buf, STR_NTILES) == 0)
			input >> iDummy;		// ntiles
		else if (strcmp(buf, STR_TILESIZE) == 0)
			input >> m_iTilesize;
		else if (strcmp(buf, STR_TEXTURESINGLE) == 0)
			m_strTextureSingle = get_line_from_stream(input);
		else if (strcmp(buf, STR_TEXTUREBASE) == 0)
			m_strTextureBase = get_line_from_stream(input);
		else if (strcmp(buf, STR_MIPMAP) == 0)
			input >> m_bMipmap;
		else if (strcmp(buf, STR_16BIT) == 0)
			input >> m_b16bit;
		else if (strcmp(buf, STR_PRELIGHT) == 0)
			input >> m_bPreLight;
		else if (strcmp(buf, STR_PRELIT) == 0)
			input >> m_bPreLit;
		else if (strcmp(buf, STR_ROADS) == 0)
			input >> m_bRoads;
		else if (strcmp(buf, STR_ROADFILE) == 0)
			m_strRoadFile = get_line_from_stream(input);
		else if (strcmp(buf, STR_HWY) == 0)
			input >> m_bHwy;
		else if (strcmp(buf, STR_PAVED) == 0)
			input >> m_bPaved;
		else if (strcmp(buf, STR_DIRT) == 0)
			input >> m_bDirt;
		else if (strcmp(buf, STR_ROADHEIGHT) == 0)
			input >> m_fRoadHeight;
		else if (strcmp(buf, STR_ROADDISTANCE) == 0)
			input >> m_fRoadDistance;
		else if (strcmp(buf, STR_TEXROADS) == 0)
			input >> m_bTexRoads;
		else if (strcmp(buf, STR_ROADCULTURE) == 0)
			input >> m_bRoadCulture;
		else if (strcmp(buf, STR_FENCES) == 0)
			input >> m_bFences;
		else if (strcmp(buf, STR_FENCEFILE) == 0)
			m_strFenceFile = get_line_from_stream(input);
		else if (strcmp(buf, STR_TREES) == 0)
			input >> m_bTrees;
		else if (strcmp(buf, STR_TREEFILE) == 0)
			m_strTreeFile = get_line_from_stream(input);
		else if (strcmp(buf, STR_TREEDISTANCE) == 0)
			input >> m_iTreeDistance;
		else if (strcmp(buf, STR_FOGDISTANCE) == 0)
			input >> m_iFogDistance;
		else if (strcmp(buf, STR_DOMOTION) == 0)
			input >> m_bDoMotion;
		else if (strcmp(buf, STR_MOTIONSCRIPT) == 0)
			m_strMotionScript = get_line_from_stream(input);
		else if (strcmp(buf, STR_VERTEXCOLORS) == 0)
			input >> m_bVertexColors;
		else if (strcmp(buf, STR_OVERLAY) == 0)
			input >> m_bOverlay;
		else if (strcmp(buf, STR_SUPPRESSLAND) == 0)
			input >> m_bSuppressLand;
		else if (strcmp(buf, STR_OCEANPLANE) == 0)
			input >> m_bOceanPlane;
		else if (strcmp(buf, STR_HORIZON) == 0)
			input >> m_bHorizon;
		else if (strcmp(buf, STR_LABELS) == 0)
			input >> m_bLabels;
		else if (strcmp(buf, STR_BUILDINGS) == 0)
			input >> m_bBuildings;
		else if (strcmp(buf, STR_BUILDINGFILE) == 0)
			m_strBuildingFile = get_line_from_stream(input);
		else if (strcmp(buf, STR_VEHICLES) == 0)
			input >> m_bVehicles;
		else if (strcmp(buf, STR_VEHICLESIZE) == 0)
			input >> m_fVehicleSize;
		else if (strcmp(buf, STR_VEHICLESPEED) == 0)
			input >> m_fVehicleSpeed;
		else if (strcmp(buf, STR_NUMCARS) == 0)
			input >> m_iNumCars;
		else if (strcmp(buf, STR_AGRICULTURE) == 0)
			input >> m_bAgriculture;
		else if (strcmp(buf, STR_WILDVEG) == 0)
			input >> m_bWildVeg;
		else if (strcmp(buf, STR_TRISTRIPS) == 0)
			input >> m_bTriStrips;
		else if (strcmp(buf, STR_DETAILTEXTURE) == 0)
			input >> m_bDetailTexture;
		else if (strcmp(buf, STR_PRELIGHTFACTOR) == 0)
			input >> m_fPreLightFactor;
		else if (strcmp(buf, STR_AIRPORTS) == 0)
			input >> m_bAirports;
		else
		{
//			cout << "Input from INI file unrecognized.\n";
			get_line_from_stream(input);
		}
	}
	m_strTextureFilename.Format("%s%d.bmp", (const char *) m_strTextureBase,
		NTILES * (m_iTilesize-1) + 1);
	return true;
}

bool TParams::SaveToFile(const char *filename)
{
	ofstream output(filename, ios::binary);
	if (!output.is_open())
		return false;

	// write to file
	output << STR_NAME << "\t\t\t";
	output << (const char *) m_strName << endl;
	output << STR_ELEVFILE << "\t\t";
	output << (const char *) m_strElevFile << endl;
	output << STR_LOCFILENAME << "\t";
	output << (const char *) m_strLocFile << endl;
	output << STR_VERTICALEXAG << "\t";
	output << m_fVerticalExag << endl;
	output << STR_MINHEIGHT << "\t\t";
	output << m_iMinHeight << endl;
	output << STR_NAVSPEED << "\t\t";
	output << m_fNavSpeed << endl;

	output << "\n";
	output << STR_REGULAR << "\t\t\t";
	output << m_bRegular << endl;
	output << STR_SUBSAMPLE << "\t\t";
	output << m_iSubsample << endl;
	output << STR_VERTEXCOLORS << "\t";
	output << m_bVertexColors << endl;

	output << "\n";
	output << STR_DYNAMIC << "\t\t\t";
	output << m_bDynamic << endl;
	output << STR_LODMETHOD << "\t\t";
	output << m_eLodMethod << endl;
	output << STR_PIXELERROR << "\t\t";
	output << m_fPixelError << endl;
	output << STR_TRICOUNT << "\t\t";
	output << m_iTriCount << endl;
	output << STR_TRISTRIPS << "\t\t";
	output << m_bTriStrips << endl;
	output << STR_DETAILTEXTURE << "\t";
	output << m_bDetailTexture << endl;

	output << "\n";
	output << STR_TIMEON << "\t\t\t";
	output << m_bTimeOn << endl;
	output << STR_INITTIME << "\t\t";
	output << m_iInitTime << endl;
	output << STR_TIMESPEED << "\t\t";
	output << m_fTimeSpeed << endl;

	output << "\n";
	output << STR_TEXTURE << "\t\t\t";
	output << m_eTexture << endl;
	output << STR_NTILES << "\t\t";
	output << NTILES << endl;
	output << STR_TILESIZE << "\t\t";
	output << m_iTilesize << endl;
	output << STR_TEXTURESINGLE << "\t";
	output << (const char *) m_strTextureSingle << endl;
	output << STR_TEXTUREBASE << "\t";
	output << (const char *) m_strTextureBase << endl;
	output << STR_MIPMAP << "\t\t\t";
	output << m_bMipmap << endl;
	output << STR_16BIT << "\t\t\t";
	output << m_b16bit << endl;
	output << STR_PRELIGHT << "\t\t";
	output << m_bPreLight << endl;
	output << STR_PRELIT << "\t\t\t";
	output << m_bPreLit << endl;
	output << STR_PRELIGHTFACTOR << "\t";
	output << m_fPreLightFactor << endl;

	output << "\n";
	output << STR_ROADS << "\t\t\t";
	output << m_bRoads << endl;
	output << STR_ROADFILE << "\t\t";
	output << (const char *) m_strRoadFile << endl;
	output << STR_HWY << "\t\t\t";
	output << m_bHwy << endl;
	output << STR_PAVED << "\t\t\t";
	output << m_bPaved << endl;
	output << STR_DIRT << "\t\t\t";
	output << m_bDirt << endl;
	output << STR_ROADHEIGHT << "\t\t";
	output << m_fRoadHeight << endl;
	output << STR_ROADDISTANCE << "\t";
	output << m_fRoadDistance << endl;
	output << STR_TEXROADS << "\t";
	output << m_bTexRoads << endl;
	output << STR_ROADCULTURE << "\t";
	output << m_bRoadCulture << endl;

	output << "\n";
	output << STR_TREES << "\t\t\t";
	output << m_bTrees << endl;
	output << STR_TREEFILE << "\t\t";
	output << (const char *) m_strTreeFile << endl;
	output << STR_TREEDISTANCE << "\t";
	output << m_iTreeDistance << endl;
	output << STR_AGRICULTURE << "\t\t";
	output << m_bAgriculture << endl;
	output << STR_WILDVEG << "\t";
	output << m_bWildVeg << endl;

	output << "\n";
	output << STR_DOMOTION << "\t\t";
	output << m_bDoMotion << endl;
	output << STR_MOTIONSCRIPT << "\t";
	output << (const char *) m_strMotionScript << endl;

	output << "\n";
	output << STR_FOG << "\t\t\t\t";
	output << m_bFog << endl;
	output << STR_FOGDISTANCE << "\t";
	output << m_iFogDistance << endl;

	output << "\n";
	output << STR_BUILDINGS << "\t\t";
	output << m_bBuildings << endl;
	output << STR_BUILDINGFILE << "\t";
	output << (const char *) m_strBuildingFile << endl;

	output << "\n";
	output << STR_VEHICLES << "\t\t";
	output << m_bVehicles << endl;
	output << STR_VEHICLESIZE << "\t";
	output << m_fVehicleSize << endl;
	output << STR_VEHICLESPEED << "\t";
	output << m_fVehicleSpeed << endl;
	output << STR_NUMCARS << "\t";
	output << m_iNumCars << endl;

	output << "\n";
	output << STR_SKY << "\t\t\t\t";
	output << m_bSky << endl;
	output << STR_OCEANPLANE << "\t\t";
	output << m_bOceanPlane << endl;
	output << STR_HORIZON << "\t\t";
	output << m_bHorizon << endl;
	output << STR_OVERLAY << "\t\t\t";
	output << m_bOverlay << endl;
	output << STR_SUPPRESSLAND << "\t";
	output << m_bSuppressLand << endl;
	output << STR_LABELS << "\t\t\t";
	output << m_bLabels << endl;

	output << STR_FENCES << "\t\t\t";
	output << m_bFences << endl;
	output << STR_FENCEFILE << "\t\t";
	output << (const char *) m_strFenceFile << endl;

	output << STR_AIRPORTS << "\t\t";
	output << m_bAirports << endl;

	return true;
}

