//
// ExtentDlg.cpp : implementation file
//
// Copyright (c) 2001 Virtual Terrain Project
// Free for all uses, see license.txt for details.
//

#include "wx/wxprec.h"
#include "ExtentDlg2.h"
#include "dialog6.h"

/////////////////////////////////////////////////////////////////////////////
// CExtentDlg dialog


BEGIN_EVENT_TABLE(CExtentDlg, AutoDialog)
	EVT_TEXT(IDC_EXTENT_E, OnChangeExtentE)
	EVT_TEXT(IDC_EXTENT_N, OnChangeExtentN)
	EVT_TEXT(IDC_EXTENT_S, OnChangeExtentS)
	EVT_TEXT(IDC_EXTENT_W, OnChangeExtentW)
	EVT_TEXT(IDC_EXTENT_ALL, OnChangeExtentAll)
END_EVENT_TABLE()

CExtentDlg::CExtentDlg(DRECT area, bool bUTM) : AutoDialog()
{
	m_strAll = _T("");
	m_strEast = _T("");
	m_strNorth = _T("");
	m_strSouth = _T("");
	m_strWest = _T("");

	m_area = area;
	m_bUTM = bUTM;
}

void CExtentDlg::FormatStrings()
{
	wxString fs;		// format string depends on coordiante scheme
	if (m_bUTM)
		fs = "%8.1f";
	else
		fs = "%4.8f";

	m_strWest.Printf(fs, m_area.left);
	m_strEast.Printf(fs, m_area.right);
	m_strNorth.Printf(fs, m_area.top);
	m_strSouth.Printf(fs, m_area.bottom);

	m_strAll.Printf("("+fs+", "+fs+"), ("+fs+", "+fs+")",
		m_area.left, m_area.bottom, m_area.Width(), m_area.Height());

	TransferDataToWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CExtentDlg message handlers

void CExtentDlg::OnInitDialog(wxInitDialogEvent& event) 
{
	AddValidator(IDC_EXTENT_ALL, &m_strAll);
	AddValidator(IDC_EXTENT_E, &m_strEast);
	AddValidator(IDC_EXTENT_N, &m_strNorth);
	AddValidator(IDC_EXTENT_S, &m_strSouth);
	AddValidator(IDC_EXTENT_W, &m_strWest);

	FormatStrings();

	wxWindow::OnInitDialog(event);
}

void CExtentDlg::OnChangeExtentE(wxCommandEvent &event) 
{
	TransferDataFromWindow();
	m_area.right = atof(m_strEast);
	FormatStrings();
}

void CExtentDlg::OnChangeExtentN(wxCommandEvent &event) 
{
	TransferDataFromWindow();
	m_area.top = atof(m_strNorth);
	FormatStrings();
}

void CExtentDlg::OnChangeExtentS(wxCommandEvent &event) 
{
	TransferDataFromWindow();
	m_area.bottom = atof(m_strSouth);
	FormatStrings();
}

void CExtentDlg::OnChangeExtentW(wxCommandEvent &event) 
{
	TransferDataFromWindow();
	m_area.left = atof(m_strWest);
	FormatStrings();	
}

void CExtentDlg::OnChangeExtentAll(wxCommandEvent &event) 
{
	TransferDataFromWindow();
	double d1, d2, d3, d4;
	int ret = sscanf(m_strAll, "(%lf, %lf), (%lf, %lf)", &d1, &d2, &d3, &d4);
	if (ret == 4)
	{
		m_area.left = d1;
		m_area.right = d1 + d3;
		m_area.bottom = d2;
		m_area.top = d2 + d4;
		FormatStrings();
	}
}
