/////////////////////////////////////////////////////////////////////////////
// Name:        ExtentDlg.cpp
// Author:      XX
// Created:     XX/XX/XX
// Copyright:   XX
/////////////////////////////////////////////////////////////////////////////

#ifdef __GNUG__
    #pragma implementation "ExtentDlg.cpp"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include "ExtentDlg.h"

// WDR: class implementations

//----------------------------------------------------------------------------
// ExtentDlg
//----------------------------------------------------------------------------

// WDR: event table for ExtentDlg

BEGIN_EVENT_TABLE(ExtentDlg,AutoDialog)
    EVT_TEXT( ID_EXTENT_N, ExtentDlg::OnExtentN )
    EVT_TEXT( ID_EXTENT_W, ExtentDlg::OnExtentW )
    EVT_TEXT( ID_EXTENT_E, ExtentDlg::OnExtentE )
    EVT_TEXT( ID_EXTENT_S, ExtentDlg::OnExtentS )
    EVT_TEXT( ID_EXTENT_ALL, ExtentDlg::OnExtentAll )
END_EVENT_TABLE()

ExtentDlg::ExtentDlg( wxWindow *parent, wxWindowID id, const wxString &title,
    const wxPoint &position, const wxSize& size, long style ) :
    AutoDialog( parent, id, title, position, size, style )
{
    ExtentDialogFunc( this, TRUE ); 
}

void ExtentDlg::SetArea(DRECT area, bool bMeters)
{
	m_area = area;
	m_bMeters = bMeters;
}

void ExtentDlg::FormatStrings()
{
	wxString fs;		// format string depends on coordiante scheme
	if (m_bMeters)
		fs = "%8.1f";
	else
		fs = "%4.8f";

	m_strWest.Printf(fs, m_area.left);
	m_strEast.Printf(fs, m_area.right);
	m_strNorth.Printf(fs, m_area.top);
	m_strSouth.Printf(fs, m_area.bottom);

	m_strAll.Printf("("+fs+", "+fs+"), ("+fs+", "+fs+")",
		m_area.left, m_area.bottom, m_area.Width(), m_area.Height());

	TransferDataToWindow();
}

// WDR: handler implementations for ExtentDlg

void ExtentDlg::OnInitDialog(wxInitDialogEvent& event) 
{
	AddValidator(ID_EXTENT_ALL, &m_strAll);
	AddValidator(ID_EXTENT_E, &m_strEast);
	AddValidator(ID_EXTENT_N, &m_strNorth);
	AddValidator(ID_EXTENT_S, &m_strSouth);
	AddValidator(ID_EXTENT_W, &m_strWest);

	FormatStrings();

	wxWindow::OnInitDialog(event);
}

void ExtentDlg::OnExtentAll( wxCommandEvent &event )
{
	TransferDataFromWindow();
	double d1, d2, d3, d4;
	int ret = sscanf(m_strAll, "(%lf, %lf), (%lf, %lf)", &d1, &d2, &d3, &d4);
	if (ret == 4)
	{
		m_area.left = d1;
		m_area.right = d1 + d3;
		m_area.bottom = d2;
		m_area.top = d2 + d4;
		FormatStrings();
	}
}

void ExtentDlg::OnExtentS( wxCommandEvent &event )
{
	TransferDataFromWindow();
	m_area.bottom = atof(m_strSouth);
	FormatStrings();
}

void ExtentDlg::OnExtentE( wxCommandEvent &event )
{
	TransferDataFromWindow();
	m_area.right = atof(m_strEast);
	FormatStrings();
}

void ExtentDlg::OnExtentW( wxCommandEvent &event )
{
	TransferDataFromWindow();
	m_area.left = atof(m_strWest);
	FormatStrings();	
}

void ExtentDlg::OnExtentN( wxCommandEvent &event )
{
	TransferDataFromWindow();
	m_area.top = atof(m_strNorth);
	FormatStrings();
}




