#include <iostream>
#include <iomanip> // for trace in hexa in rw port
#include "./cpu/z80.h"
#include "SmsEnvironment.h"

using namespace std;

/** Constructor. */
SmsEnvironment::SmsEnvironment() {
}

/** Destructor. */
SmsEnvironment::~SmsEnvironment() {
}

unsigned char SmsEnvironment::readByte( unsigned addr ) {

    return mmapper->rd8(addr & 0xFFFF);
}

void SmsEnvironment::writeByte( unsigned addr, unsigned char value ) {

    mmapper->wr8(addr & 0xFFFF, value);
}

unsigned char SmsEnvironment::readPort( unsigned port ) {
    
    unsigned char r = iomapper->in8(port & 0xff);
    return r;
}

void SmsEnvironment::writePort( unsigned port, unsigned char value ) {

    iomapper->out8(port & 0xff,value);
}

/**
    Called immediately after a RETI is executed.
*/
void SmsEnvironment::onReturnFromInterrupt() {
}

void SmsEnvironment::onInterruptsEnabled() {
    if (v->sms_irq == true)
    {
        cpu->interrupt(0xff);
	v->sms_irq = false;
    }
}

void SmsEnvironment::setMemoryMapper(MemoryMapper *m) {
    mmapper = m;
}

void SmsEnvironment::setIOMapper(IOMapper *m) {
    iomapper = m;
}

void SmsEnvironment::setVDP(VDP *vdp) {
    v = vdp;
}

void SmsEnvironment::setCPU(Z80 *c) {
    cpu = c;
}
