/*****************************************************************************
*
* File: SmsDebugger.h
*
* Project: Osmose emulator.
*
* Description: This class will handle built-in debugger. 
*
* Author: Vedder Bruno
* Date: 16/10/2004, 18h00
*
* URL: http://bcz.emu-france.com/
*****************************************************************************/
#ifndef SMS_DEBUGGER_H
#define SMS_DEBUGGER_H

#include "SmsEnvironment.h"
#include "IOMapper.h"
#include "MemoryMapper.h"
#include "z80_disasm/Z80Dasm.h"
#include "VDP.h"

using namespace std;

#define MAX_BREAKPOINTS 16

class SmsDebugger
{
protected:

    MemoryMapper   *mem;
    SmsEnvironment *env;
    VDP	           *v;  
    IOMapper       *iom;
    Z80Dasm 	   *dasm;
    Z80		   *cpu;
    
public:
    SmsDebugger();
    void setCPU(Z80 *c) {cpu = c;}
    void setMemoryMapper(MemoryMapper *mm) {mem = mm;}
    void setEnvironment(SmsEnvironment *se){env = se;}
    void setVDP(VDP *vd) {v = vd;}
    void setIOMapper(IOMapper *im){iom = im;}
    void setDasm(Z80Dasm *d){dasm = d;}    
    void beginSession();
    bool enter();

private:
    bool any_breakpoint;	      /* Flag to avoid bp search.	 */
    bool end_session;		      /* Have we leaved the debugger ?   */
    int breakpoints[MAX_BREAKPOINTS]; /* INTeger chose to allow -1 value */
    unsigned int bp_index;	      /* Index in circular buffer of bp. */
    void help();
    void dpr();
    void dvdpr();
    void vdpi();
    void dvram();
    void dumpRegisters();
    void clearBreakpoints();
    void addBreakpoint(int add);
    void listBreakpoints();
};
#endif
