/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.test.optimization;

import com.cenqua.clover.Logger;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.test.optimization.Snapshot;
import java.io.File;

public final class Options {
    private static final int NO_REORDER = 0;
    private static final int FAILFAST_REORDER = 1;
    private static final int RANDOM_REORDER = 2;
    private boolean enabled;
    private boolean minimize;
    private int reorder;
    private boolean debug;
    private int maxCompilesBeforeStaleSnapshot;
    private Logger logger;
    private String optimizableName;
    private File snapshot;
    private String initString;

    private Options() {
    }

    public static Options newDefaults() {
        return new Options().enabled(true).minimize(true).reorderFailfast().withOptimizableCalled("test").maxCompilesBeforeStaleSnapshot(10).debug(false);
    }

    public Options withSnapshotAt(File snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public Options withInitString(String initString) {
        this.initString = initString;
        return this;
    }

    public Options withDefaultInitString(InstrumentationConfig config) {
        return this.withInitString(config.resolveInitString());
    }

    public Options withDefaultInitStringAndSnapshotFrom(InstrumentationConfig config) {
        return this.withInitString(config.resolveInitString()).withSnapshotAt(Snapshot.fileForInitString(config.resolveInitString()));
    }

    public Options withOptimizableCalled(String name) {
        this.optimizableName = name;
        return this;
    }

    public Options logWith(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Options enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Options minimize(boolean minimize) {
        this.minimize = minimize;
        return this;
    }

    public Options reorderFailfast() {
        this.reorder = 1;
        return this;
    }

    public Options dontReorder() {
        this.reorder = 0;
        return this;
    }

    public Options reorderRandomly() {
        this.reorder = 2;
        return this;
    }

    public Options reorder(int reorder) {
        this.reorder = reorder;
        return this;
    }

    public Options maxCompilesBeforeStaleSnapshot(int maxCompilesBeforeStaleSnapshot) {
        this.maxCompilesBeforeStaleSnapshot = maxCompilesBeforeStaleSnapshot;
        return this;
    }

    public Options debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public boolean isReorderFailfast() {
        return this.getReorder() == 1;
    }

    public boolean isReordering() {
        return this.getReorder() == 0;
    }

    public boolean isReorderRandomly() {
        return this.getReorder() == 2;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public String getOptimizableName() {
        return this.optimizableName;
    }

    public int getReorder() {
        return this.reorder;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxCompilesBeforeStaleSnapshot() {
        return this.maxCompilesBeforeStaleSnapshot;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getInitString() {
        return this.initString;
    }

    public File getSnapshotFile() {
        return this.snapshot;
    }

    public String toString() {
        return "Options{enabled=" + this.enabled + ", minimize=" + this.minimize + ", reorder=" + this.reorder + ", debug=" + this.debug + ", maxCompilesBeforeStaleSnapshot=" + this.maxCompilesBeforeStaleSnapshot + ", optimizableName='" + this.optimizableName + '\'' + ", initString='" + this.initString + '\'' + ", snapshot=" + this.snapshot + '}';
    }
}

