/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.AntLogger;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractCloverTask
extends Task {
    protected AntInstrumentationConfig config;

    public void init() throws BuildException {
        super.init();
        Logger.setInstance(new AntLogger(this.getProject(), this));
        this.config = new AntInstrumentationConfig(this.getProject());
    }

    public String getInitString() {
        return this.config.getInitString();
    }

    public void setInitString(String initString) {
        this.config.setInitstring(initString);
    }

    protected String resolveInitString() throws BuildException {
        return this.config.resolveInitString();
    }

    public final void execute() {
        if (this.config == null) {
            throw new BuildException("Configuration is null. This Task not initialiased correctly. Please ensure init() is called before execute().");
        }
        String antLicensePath = this.getProject().getProperty("clover.license.path");
        if (antLicensePath != null && antLicensePath.length() > 0) {
            System.setProperty("clover.license.path", antLicensePath);
        }
        CloverStartup.loadLicense(Logger.getInstance());
        if (this.validate()) {
            this.cloverExecute();
        }
    }

    public boolean validate() {
        return true;
    }

    public abstract void cloverExecute();

    public void setTmpDir(File tmpDir) {
        this.config.setTmpDir(tmpDir);
    }
}

