/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import com.cenqua.clover.BitSetCoverageProvider;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.util.CloverUtils;
import com.cenqua.clover.util.Formatting;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RenderTestResultAction
implements Callable {
    private final HtmlRenderingSupport mHelper;
    private final Current mCfg;
    private final ProjectInfo mFullModel;
    private final TestCaseInfo mTest;
    private final VelocityContext mContext;
    private final CloverDatabase mDb;
    private final ProjectInfo mReadOnlyModel;
    private static final ThreadLocal REUSABLE_MODEL = new ThreadLocal();
    private static final ThreadLocal CONFIGURABLE_MODEL = new ThreadLocal();
    private static final Comparator TARGET_CLASS_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object1) {
            BlockMetrics m = ((HasMetrics)object).getMetrics();
            BlockMetrics m1 = ((HasMetrics)object1).getMetrics();
            float difference = 1000.0f * (m1.getPcCoveredElements() - m.getPcCoveredElements());
            return (int)difference;
        }
    };

    public RenderTestResultAction(TestCaseInfo test, HtmlRenderingSupport helper, Current config, ProjectInfo configuredModel, VelocityContext context, ProjectInfo fullModel, CloverDatabase db) {
        this.mHelper = helper;
        this.mCfg = config;
        this.mReadOnlyModel = configuredModel;
        this.mTest = test;
        this.mContext = context;
        this.mFullModel = fullModel;
        this.mDb = db;
    }

    public Object call() throws Exception {
        if (REUSABLE_MODEL.get() == null) {
            REUSABLE_MODEL.set(this.mReadOnlyModel.copy());
        }
        if (CONFIGURABLE_MODEL.get() == null) {
            CONFIGURABLE_MODEL.set(this.mReadOnlyModel.copy());
        }
        FileInfo finfo = (FileInfo)this.mTest.getRuntimeType().getContainingFile();
        StringBuffer outname = this.mHelper.getTestFileName(this.mTest);
        File outfile = CloverUtils.createOutFile(finfo, outname.toString(), this.mCfg.getOutFile());
        ProjectInfo projectInfo = (ProjectInfo)CONFIGURABLE_MODEL.get();
        projectInfo.setDataProvider(new BitSetCoverageProvider(this.mDb.getCoverageData().getHitsFor(this.mTest)));
        List classes = this.getCoverageByTest(projectInfo);
        if (this.mCfg.isShowUniqueCoverage()) {
            this.gatherUniquenessVariables(classes);
        } else {
            this.mContext.put("showUnique", Boolean.FALSE);
        }
        this.mContext.put("currentPageURL", outname);
        Collections.sort(classes, TARGET_CLASS_COMPARATOR);
        this.mContext.put("targetClasses", classes);
        this.mContext.put("test", this.mTest);
        this.mContext.put("topLevel", Boolean.TRUE);
        this.mContext.put("projInfo", this.mFullModel);
        this.mContext.put("hasResults", this.mFullModel.hasTestResults());
        HtmlReportUtil.mergeTemplateToFile(outfile, this.mContext, "html_res/test-summary.vm");
        return null;
    }

    private void gatherUniquenessVariables(List classes) {
        LinkedHashMap uniqueCoverageMap = new LinkedHashMap();
        float uniqueElementsHit = this.buildUniqueCoverageMap(this.mTest, uniqueCoverageMap);
        int totalElementsHit = 0;
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            ClassInfo info = (ClassInfo)iterator.next();
            totalElementsHit += info.getMetrics().getNumCoveredElements();
        }
        float pcUniqueElementsHit = (float)totalElementsHit > 0.0f ? uniqueElementsHit / (float)totalElementsHit : 0.0f;
        String pcUniqueCoverage = Formatting.getPercentStr(pcUniqueElementsHit);
        this.mContext.put("showUnique", Boolean.TRUE);
        this.mContext.put("uniqueTargetClasses", uniqueCoverageMap);
        this.mContext.put("pcUniqueCoverage", pcUniqueCoverage);
    }

    private int buildUniqueCoverageMap(TestCaseInfo tci, Map uniqueCoverageMap) {
        ProjectInfo projectInfo = this.createUniqueCoverageModel(tci);
        List uniqueClassesCovered = this.getCoverageByTest(projectInfo);
        Collections.sort(uniqueClassesCovered, TARGET_CLASS_COMPARATOR);
        int uniqueElementsHit = 0;
        Iterator iterator = uniqueClassesCovered.iterator();
        while (iterator.hasNext()) {
            ClassInfo info = (ClassInfo)iterator.next();
            uniqueCoverageMap.put(info.getQualifiedName(), info);
            uniqueElementsHit += info.getMetrics().getNumCoveredElements();
        }
        return uniqueElementsHit;
    }

    private ProjectInfo createUniqueCoverageModel(TestCaseInfo tci) {
        ProjectInfo projectInfo = (ProjectInfo)REUSABLE_MODEL.get();
        projectInfo.setDataProvider(new BitSetCoverageProvider(this.mDb.getCoverageData().getUniqueHitsFor(tci)));
        return projectInfo;
    }

    private List getCoverageByTest(ProjectInfo projectInfo) {
        return projectInfo.getClasses(new HasMetricsFilter(){

            public boolean accept(HasMetrics hm) {
                return !((ClassInfo)hm).isTestClass() && hm.getMetrics().getNumCoveredElements() > 0;
            }
        });
    }
}

