/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.html.HtmlReporter;
import com.cenqua.clover.reporters.json.JSONReporter;
import com.cenqua.clover.reporters.pdf.PDFReporter;
import com.cenqua.clover.reporters.xml.XMLReporter;

public class CloverReporter {
    public static void generateReport(CloverReportConfig cfg) throws CloverException {
        if (!cfg.validate()) {
            throw new CloverException(cfg.getValidationFailureReason());
        }
        String type = cfg.getFormat().getType();
        if (type.equals("PDF")) {
            PDFReporter.generateReport(cfg);
        } else if (type.equals("XML")) {
            XMLReporter.generateReport(cfg);
        } else if (type.equals("HTML")) {
            HtmlReporter.generateReport(cfg);
        } else if (type.equals("JSON")) {
            JSONReporter.generateReport(cfg);
        } else {
            throw new CloverException("Unsupported report format '" + type + "'");
        }
    }
}

