/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.StackTraceInfo;
import com.cenqua.clover.registry.StatementInfo;

public class LineInfo {
    private int line;
    private ClassInfo[] classStarts;
    private MethodInfo[] methodStarts;
    private StatementInfo[] statements;
    private BranchInfo[] branches;
    private StackTraceInfo.TraceEntry[] failStackEntries;

    public LineInfo(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public ClassInfo[] getClassStarts() {
        return this.classStarts;
    }

    public MethodInfo[] getMethodStarts() {
        return this.methodStarts;
    }

    public StatementInfo[] getStatements() {
        return this.statements;
    }

    public BranchInfo[] getBranches() {
        return this.branches;
    }

    public StackTraceInfo.TraceEntry[] getFailStackEntries() {
        return this.failStackEntries;
    }

    void addClassStart(ClassInfo clazz) {
        if (this.classStarts == null) {
            this.classStarts = new ClassInfo[1];
        } else {
            ClassInfo[] newData = new ClassInfo[this.classStarts.length + 1];
            System.arraycopy(this.classStarts, 0, newData, 0, this.classStarts.length);
            this.classStarts = newData;
        }
        this.classStarts[this.classStarts.length - 1] = clazz;
    }

    void addMethodStart(MethodInfo method) {
        if (this.methodStarts == null) {
            this.methodStarts = new MethodInfo[1];
        } else {
            MethodInfo[] newData = new MethodInfo[this.methodStarts.length + 1];
            System.arraycopy(this.methodStarts, 0, newData, 0, this.methodStarts.length);
            this.methodStarts = newData;
        }
        this.methodStarts[this.methodStarts.length - 1] = method;
    }

    void addStatement(StatementInfo stmt) {
        if (this.statements == null) {
            this.statements = new StatementInfo[1];
        } else {
            StatementInfo[] newData = new StatementInfo[this.statements.length + 1];
            System.arraycopy(this.statements, 0, newData, 0, this.statements.length);
            this.statements = newData;
        }
        this.statements[this.statements.length - 1] = stmt;
    }

    void addBranch(BranchInfo branch) {
        if (this.branches == null) {
            this.branches = new BranchInfo[1];
        } else {
            BranchInfo[] newData = new BranchInfo[this.branches.length + 1];
            System.arraycopy(this.branches, 0, newData, 0, this.branches.length);
            this.branches = newData;
        }
        this.branches[this.branches.length - 1] = branch;
    }

    public void setFailStackEntries(StackTraceInfo.TraceEntry[] entries) {
        this.failStackEntries = new StackTraceInfo.TraceEntry[entries.length];
        System.arraycopy(entries, 0, this.failStackEntries, 0, entries.length);
    }
}

