/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;

public class StatementInstrEmitter
extends Emitter {
    private int endLine;
    private int endCol;
    private int complexity;
    private StatementInfo stmtInfo;

    public StatementInstrEmitter(ContextSet context, int line, int column, int endLine, int endCol) {
        this(context, line, column, endLine, endCol, 0);
    }

    public StatementInstrEmitter(ContextSet context, int line, int column, int endLine, int endCol, int complexity) {
        super(context, line, column);
        this.endLine = endLine;
        this.endCol = endCol;
        this.complexity = complexity;
    }

    public void init(InstrumentationState state) {
        this.stmtInfo = state.getRegistry().addStatement(this.getElementContext(), new SourceRegion(this.getLine(), this.getColumn(), this.endLine, this.endCol), this.complexity);
        if (state.isInstrEnabled()) {
            state.setDirty();
            this.setInstr(state.getRecorderPrefix() + ".inc(" + this.stmtInfo.getDataIndex() + ");");
        }
    }

    public void addContext(NamedContext ctx) {
        super.addContext(ctx);
        if (this.stmtInfo != null) {
            this.stmtInfo.addContext(ctx);
        }
    }
}

