/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.CloverToken;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.TokenListUtil;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class MethodSignature
implements Serializable {
    private static final long serialVersionUID = 2456494942827618143L;
    private static final String[] EMPTY = new String[0];
    private static final Parameter[] EMPTY_PARAMS = new Parameter[0];
    private Map tags = new HashMap();
    private Modifiers modifiers;
    private String name;
    private String typeParam;
    private String returnType;
    private Parameter[] parameters;
    private String[] throwsTypes;
    public transient String normSeqPrefix;
    public transient String normSeqSuffix;

    public MethodSignature(String name) {
        this.name = name;
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, String name, String typeParam, String returnType, Parameter[] parameters, String[] throwsTypes) {
        this(firstToken, nameToken, lastToken, new HashMap(), new Modifiers(), name, typeParam, returnType, parameters, throwsTypes);
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, Map tags, Modifiers modifiers, String name, String typeParam, String returnType, Parameter[] parameters, String[] throwsTypes) {
        if (firstToken != null || lastToken != null) {
            int mods = modifiers.getModifiers();
            mods &= 0xFFFFFFFA;
            this.normSeqPrefix = Modifier.toString(mods |= 2) + (typeParam != null ? " " + typeParam : "") + (returnType != null ? " " + returnType : "") + " ";
            this.normSeqSuffix = TokenListUtil.getNormalisedSequence(nameToken.getNext(), lastToken);
        }
        this.tags = tags;
        this.modifiers = modifiers;
        this.name = name;
        this.typeParam = typeParam;
        this.returnType = returnType;
        this.parameters = this.flyweightIfEmptyFor(parameters);
        this.throwsTypes = this.flyweightIfEmptyFor(throwsTypes);
    }

    public Map getTags() {
        return this.tags;
    }

    public int getModifiers() {
        return this.modifiers.getModifiers();
    }

    void setModifiers(int modifiers) {
        this.modifiers.setModifiers(modifiers);
    }

    public Modifiers getFullModifiers() {
        return this.modifiers;
    }

    public Map getAnnotations() {
        return this.modifiers.getAnnotations();
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean hasParams() {
        return this.parameters != null && this.parameters.length > 0;
    }

    public int getParamCount() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    public String listParamTypes() {
        StringBuffer types = new StringBuffer();
        String sep = "";
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            types.append(sep);
            types.append(this.parameters[i].getType());
            sep = ",";
        }
        return types.toString();
    }

    public String listParamIdents() {
        StringBuffer idents = new StringBuffer();
        String sep = "";
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            idents.append(sep);
            idents.append(this.parameters[i].getName());
            sep = ",";
        }
        return idents.toString();
    }

    public String[] getThrowsTypes() {
        return this.throwsTypes;
    }

    void setName(String name) {
        this.name = name;
    }

    String getRenamedNormalisedSignature(String newName) {
        if (this.normSeqPrefix == null) {
            throw new IllegalStateException("This signature is not renameable.");
        }
        StringBuffer renamed = new StringBuffer();
        renamed.append(this.normSeqPrefix);
        renamed.append(" ");
        renamed.append(newName);
        renamed.append(this.normSeqSuffix);
        return renamed.toString();
    }

    private final String[] flyweightIfEmptyFor(String[] strings) {
        return strings != null && strings.length == 0 ? EMPTY : strings;
    }

    private final Parameter[] flyweightIfEmptyFor(Parameter[] params) {
        return params != null && params.length == 0 ? EMPTY_PARAMS : params;
    }

    public static class Parameter
    implements Serializable {
        private static final long serialVersionUID = 3328563398513782431L;
        private final String type;
        private final String name;

        public Parameter(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

