/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.instr.DefaultTestDetector;
import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.util.CloverUtils;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodRegistrationNode
extends Emitter {
    private static final Map DEFAULT_RETURN_VALUES;
    private MethodSignature signature;
    private MethodInfo method;

    public MethodRegistrationNode(ContextSet context, MethodSignature signature, int line, int col) {
        super(context, line, col);
        this.signature = signature;
    }

    protected boolean acceptsContextType(NamedContext context) {
        return context instanceof MethodRegexpContext;
    }

    public void init(InstrumentationState state) {
        InstrumentationConfig cfg = state.getCfg();
        boolean isTestMethod = state.isDetectTests() && state.getTestDetector().isMethodMatch(state, this.signature);
        String javaLangPrefix = cfg.getJavaLangPrefix();
        boolean addTestRewriteInstr = state.isInstrEnabled() && cfg.isTestRewriting() && isTestMethod;
        this.method = state.getRegistry().enterMethod(this.getElementContext(), new SourceRegion(this.getLine(), this.getColumn()), this.signature, isTestMethod);
        if (addTestRewriteInstr) {
            boolean nonVoidReturn;
            List<String> expectedExceptions = state.isDetectTests() ? Arrays.asList(DefaultTestDetector.getExpectedExceptionsFor(state, this.signature)) : Collections.EMPTY_LIST;
            boolean expectsExceptions = expectedExceptions.size() > 0;
            String syntheticTestName = CloverUtils.createSyntheticTestName(this.method);
            StringBuffer instr = new StringBuffer();
            instr.append("{");
            instr.append(state.getRecorderPrefix());
            String typeInstr = "getClass().getName()";
            if (Modifier.isStatic(this.getSignature().getModifiers())) {
                typeInstr = this.getMethod().getContainingClass().getName() + ".class.getName()";
            }
            instr.append(".globalSliceStart(").append(typeInstr).append(",").append(this.method.getDataIndex()).append(");");
            instr.append("int ").append(MethodRegistrationNode.namespace("p")).append("=").append(0).append(";");
            instr.append(javaLangPrefix).append("Throwable ").append(MethodRegistrationNode.namespace("t")).append("=null;");
            instr.append("try{");
            boolean bl = nonVoidReturn = this.signature.getReturnType() != null && !"void".equals(this.signature.getReturnType());
            if (nonVoidReturn) {
                instr.append(this.signature.getReturnType()).append(" ").append(MethodRegistrationNode.namespace("r")).append("=");
            }
            instr.append(syntheticTestName);
            instr.append("(").append(this.signature.listParamIdents()).append(");");
            instr.append(MethodRegistrationNode.namespace("p")).append("=");
            if (expectsExceptions) {
                int i;
                instr.append(0).append(";").append(MethodRegistrationNode.namespace("t")).append("=new ").append(javaLangPrefix).append("RuntimeException(");
                StringBuffer msgBuffer = new StringBuffer();
                msgBuffer.append("Expected one of the following exceptions to be thrown from test method ").append(this.method.getSimpleName()).append(": ").append("[");
                for (i = 0; i < expectedExceptions.size(); ++i) {
                    String expectedException = expectedExceptions.get(i);
                    msgBuffer.append(expectedException).append(i < expectedExceptions.size() - 1 ? ", " : "");
                }
                msgBuffer.append("]");
                instr.append("new String(new char[] {");
                for (i = 0; i < msgBuffer.length(); ++i) {
                    instr.append((int)msgBuffer.charAt(i)).append(",");
                }
                instr.append("}));");
            } else {
                instr.append(1).append(";");
            }
            if (nonVoidReturn) {
                instr.append("return ").append(MethodRegistrationNode.namespace("r")).append(";");
            }
            instr.append("}catch(").append(javaLangPrefix).append("Throwable ").append(MethodRegistrationNode.namespace("t2")).append(")").append("{");
            if (expectsExceptions) {
                instr.append("if(");
                for (int i = 0; i < expectedExceptions.size(); ++i) {
                    String expectedException = expectedExceptions.get(i);
                    instr.append(MethodRegistrationNode.namespace("t2")).append(" instanceof ").append(expectedException);
                    if (i >= expectedExceptions.size() - 1) continue;
                    instr.append("||");
                }
                instr.append("){").append(MethodRegistrationNode.namespace("p")).append("=").append(1).append(";").append(MethodRegistrationNode.namespace("t")).append("=null;}else{").append(MethodRegistrationNode.namespace("p")).append("=").append(0).append(";").append(MethodRegistrationNode.namespace("t")).append("=").append(MethodRegistrationNode.namespace("t2")).append(";}");
            }
            instr.append("if(").append(MethodRegistrationNode.namespace("p")).append("==").append(0).append("&&").append(MethodRegistrationNode.namespace("t")).append("==null){").append(MethodRegistrationNode.namespace("t")).append("=").append(MethodRegistrationNode.namespace("t2")).append(";}");
            instr.append(state.getRecorderPrefix()).append(".rethrow(").append(MethodRegistrationNode.namespace("t2")).append(");");
            if (nonVoidReturn) {
                instr.append("return ").append(MethodRegistrationNode.defaultNullValueForType(this.signature.getReturnType())).append(";");
            }
            instr.append("}");
            instr.append("finally{");
            instr.append(state.getRecorderPrefix());
            instr.append(".globalSliceEnd(").append(typeInstr).append(",\"").append(this.method.getQualifiedName()).append("\",").append(this.method.getDataIndex()).append(",").append(MethodRegistrationNode.namespace("p")).append(",").append(MethodRegistrationNode.namespace("t")).append(");");
            instr.append("}}");
            instr.append(this.signature.getRenamedNormalisedSignature(syntheticTestName));
            this.setInstr(instr.toString());
        }
    }

    private static String defaultNullValueForType(String returnType) {
        return String.valueOf(DEFAULT_RETURN_VALUES.get(returnType));
    }

    public static String namespace(String var) {
        return "$CLV_" + var + "$";
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public void addContext(NamedContext ctx) {
        super.addContext(ctx);
        if (this.method != null) {
            this.method.addContext(ctx);
        }
    }

    static {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("boolean", "false");
        values.put("byte", "0");
        values.put("short", "0");
        values.put("char", "0");
        values.put("int", "0");
        values.put("long", "0l");
        values.put("float", "0f");
        values.put("double", "0d");
        DEFAULT_RETURN_VALUES = Collections.unmodifiableMap(values);
    }
}

