/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.AggregateTestDetector;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.OrStrategy;
import com.cenqua.clover.instr.TestDetector;
import com.cenqua.clover.instr.TestSourceMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileMappedTestDetector
implements TestDetector {
    private List testFileMatchers = new ArrayList();
    private TestDetector defaultDetector = null;

    public FileMappedTestDetector() {
    }

    public FileMappedTestDetector(TestDetector defaultDetector) {
        this.defaultDetector = defaultDetector;
    }

    public void addTestSourceMatcher(TestSourceMatcher matcher) {
        this.testFileMatchers.add(matcher);
    }

    public TestDetector getDetectorForFile(File f) {
        AggregateTestDetector detectors = new AggregateTestDetector(new OrStrategy());
        Iterator matchers = this.testFileMatchers.iterator();
        while (matchers.hasNext()) {
            TestSourceMatcher matcher = (TestSourceMatcher)matchers.next();
            if (!matcher.matchesFile(f)) continue;
            detectors.addDetector(matcher.getDetector());
        }
        return detectors.isEmpty() ? this.defaultDetector : detectors;
    }

    public boolean isClassMatch(InstrumentationState state, Map tags, Modifiers mods, String pkgName, String classname, String superclass) {
        TestDetector t = this.getDetectorForFile(state.getStructure().getFile());
        return t != null && t.isClassMatch(state, tags, mods, pkgName, classname, superclass);
    }

    public boolean isMethodMatch(InstrumentationState state, MethodSignature sig) {
        TestDetector t = this.getDetectorForFile(state.getStructure().getFile());
        return t != null && t.isMethodMatch(state, sig);
    }
}

