/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.ExpressionInfo;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.SourceRegion;

public class EndBoolInstrEmitter
extends Emitter {
    private ExpressionInfo expr;
    private int endline;
    private int endcol;
    private BranchInfo branchInfo;

    public EndBoolInstrEmitter(ContextSet context, int line, int column, int endline, int endcol, ExpressionInfo expr) {
        super(context, line, column);
        this.endline = endline;
        this.endcol = endcol;
        this.expr = expr;
        this.setInstr(")))");
    }

    public void init(InstrumentationState state) {
        this.branchInfo = state.getRegistry().addBranch(this.getElementContext(), new SourceRegion(this.getLine(), this.getColumn(), this.endline, this.endcol), this.expr.getComplexity(), this.expr.isInstrumentable());
        if (state.isInstrEnabled() && this.branchInfo != null && this.expr.isInstrumentable()) {
            int index = this.branchInfo.getDataIndex();
            state.setDirty();
            this.setInstr(")&&(" + state.getRecorderPrefix() + ".iget(" + index + ")!=0|true))||(" + state.getRecorderPrefix() + ".iget(" + (index + 1) + ")==0&false))");
        }
    }

    public void addContext(NamedContext ctx) {
        super.addContext(ctx);
        if (this.branchInfo != null) {
            this.branchInfo.addContext(ctx);
        }
    }
}

