/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.Logger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FOSFactory {
    private static final boolean USE_SYNCHRONOUS_IO;

    public static FileOutputStream newFOS(String name) throws FileNotFoundException {
        if (USE_SYNCHRONOUS_IO) {
            return new SyncingFileOutputStream(name);
        }
        return new FileOutputStream(name);
    }

    static {
        Boolean useSyncIO = Boolean.FALSE;
        try {
            useSyncIO = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(System.getProperty("clover.synchronous.io"));
                }
            });
        }
        catch (SecurityException e) {
            Logger.getInstance().info("Unable to determine Clover IO mode", e);
        }
        USE_SYNCHRONOUS_IO = useSyncIO != null ? useSyncIO : false;
    }

    private static class SyncingFileOutputStream
    extends FileOutputStream {
        private SyncingFileOutputStream(String name) throws FileNotFoundException {
            super(name);
        }

        public void flush() throws IOException {
            super.flush();
            this.getFD().sync();
        }
    }
}

