/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.commons.lang.builder;

import clover.org.apache.commons.lang.math.NumberUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Comparator;

public class CompareToBuilder {
    private int comparison = 0;

    public CompareToBuilder append(byte lhs, byte rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(char lhs, char rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(double lhs, double rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = NumberUtils.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(float lhs, float rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = NumberUtils.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(int lhs, int rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(long lhs, long rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(Object lhs, Object rhs) {
        return this.append(lhs, rhs, null);
    }

    public CompareToBuilder append(Object lhs, Object rhs, Comparator comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.getClass().isArray()) {
            if (lhs instanceof long[]) {
                this.append((long[])lhs, (long[])rhs);
            } else if (lhs instanceof int[]) {
                this.append((int[])lhs, (int[])rhs);
            } else if (lhs instanceof short[]) {
                this.append((short[])lhs, (short[])rhs);
            } else if (lhs instanceof char[]) {
                this.append((char[])lhs, (char[])rhs);
            } else if (lhs instanceof byte[]) {
                this.append((byte[])lhs, (byte[])rhs);
            } else if (lhs instanceof double[]) {
                this.append((double[])lhs, (double[])rhs);
            } else if (lhs instanceof float[]) {
                this.append((float[])lhs, (float[])rhs);
            } else if (lhs instanceof boolean[]) {
                this.append((boolean[])lhs, (boolean[])rhs);
            } else {
                this.append((Object[])lhs, (Object[])rhs, comparator);
            }
        } else {
            this.comparison = comparator == null ? ((Comparable)lhs).compareTo(rhs) : comparator.compare(lhs, rhs);
        }
        return this;
    }

    public CompareToBuilder append(short lhs, short rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(boolean lhs, boolean rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        this.comparison = !lhs ? -1 : 1;
        return this;
    }

    public CompareToBuilder append(byte[] lhs, byte[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(char[] lhs, char[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(double[] lhs, double[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(float[] lhs, float[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(int[] lhs, int[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(long[] lhs, long[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs) {
        return this.append(lhs, rhs, (Comparator)null);
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs, Comparator comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i], comparator);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(short[] lhs, short[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder append(boolean[] lhs, boolean[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        int i = 0;
        while (i < lhs.length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        return this;
    }

    public CompareToBuilder appendSuper(int superCompareTo) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = superCompareTo;
        return this;
    }

    private static void reflectionAppend(Object lhs, Object rhs, Class clazz, CompareToBuilder builder, boolean useTransients) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        int i = 0;
        while (i < fields.length && builder.comparison == 0) {
            AccessibleObject f = fields[i];
            if (!(((Field)f).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers()))) {
                try {
                    builder.append(((Field)f).get(lhs), ((Field)f).get(rhs));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            ++i;
        }
    }

    public static int reflectionCompare(Object lhs, Object rhs) {
        return CompareToBuilder.reflectionCompare(lhs, rhs, false, null);
    }

    public static int reflectionCompare(Object lhs, Object rhs, boolean compareTransients) {
        return CompareToBuilder.reflectionCompare(lhs, rhs, compareTransients, null);
    }

    public static int reflectionCompare(Object lhs, Object rhs, boolean compareTransients, Class reflectUpToClass) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        Class<?> lhsClazz = lhs.getClass();
        if (!lhsClazz.isInstance(rhs)) {
            throw new ClassCastException();
        }
        CompareToBuilder compareToBuilder = new CompareToBuilder();
        CompareToBuilder.reflectionAppend(lhs, rhs, lhsClazz, compareToBuilder, compareTransients);
        while (lhsClazz.getSuperclass() != null && lhsClazz != reflectUpToClass) {
            lhsClazz = lhsClazz.getSuperclass();
            CompareToBuilder.reflectionAppend(lhs, rhs, lhsClazz, compareToBuilder, compareTransients);
        }
        return compareToBuilder.toComparison();
    }

    public int toComparison() {
        return this.comparison;
    }
}

