/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.bytes.ByteComparator;
import clover.it.unimi.dsi.fastutil.ints.IntArrays;

public class ByteSemiIndirectHeaps {
    private ByteSemiIndirectHeaps() {
    }

    public static int downHeap(byte[] refArray, int[] heap, int size, int i, ByteComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        byte E = refArray[e];
        if (c == null) {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && refArray[heap[child + 1]] < refArray[heap[child]]) {
                    ++child;
                }
                if (E > refArray[heap[child]]) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && c.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (c.compare(E, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(byte[] refArray, int[] heap, int size, int i, ByteComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        byte E = refArray[e];
        if (c == null) {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && refArray[heap[parent]] > E) {
                heap[i] = heap[parent];
                i = parent;
            }
        } else {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && c.compare(refArray[heap[parent]], E) > 0) {
                heap[i] = heap[parent];
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(byte[] refArray, int offset, int length, int[] heap, ByteComparator c) {
        ByteArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
        }
        i = length / 2;
        while (i-- != 0) {
            ByteSemiIndirectHeaps.downHeap(refArray, heap, length, i, c);
        }
    }

    public static int[] makeHeap(byte[] refArray, int offset, int length, ByteComparator c) {
        int[] heap = length <= 0 ? IntArrays.EMPTY_ARRAY : new int[length];
        ByteSemiIndirectHeaps.makeHeap(refArray, offset, length, heap, c);
        return heap;
    }

    public static void makeHeap(byte[] refArray, int[] heap, int size, ByteComparator c) {
        int i = size / 2;
        while (i-- != 0) {
            ByteSemiIndirectHeaps.downHeap(refArray, heap, size, i, c);
        }
    }
}

