/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.tools;

import clover.com.lowagie.text.pdf.PdfEncryptor;
import clover.com.lowagie.text.pdf.PdfReader;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class encrypt_pdf {
    private static final int INPUT_FILE = 0;
    private static final int OUTPUT_FILE = 1;
    private static final int USER_PASSWORD = 2;
    private static final int OWNER_PASSWORD = 3;
    private static final int PERMISSIONS = 4;
    private static final int STRENGTH = 5;
    private static final int[] permit = new int[]{2052, 8, 16, 32, 256, 512, 1024, 4};

    private static void usage() {
        System.out.println("usage: input_file output_file user_password owner_password permissions 128|40");
        System.out.println("permissions is 8 digit long 0 or 1. Each digit has a particular security function:");
        System.out.println();
        System.out.println("AllowPrinting");
        System.out.println("AllowModifyContents");
        System.out.println("AllowCopy");
        System.out.println("AllowModifyAnnotations");
        System.out.println("AllowFillIn (128 bit only)");
        System.out.println("AllowScreenReaders (128 bit only)");
        System.out.println("AllowAssembly (128 bit only)");
        System.out.println("AllowDegradedPrinting (128 bit only)");
        System.out.println("Example permissions to copy and print would be: 10100000");
    }

    public static void main(String[] stringArray) {
        System.out.println("PDF document encryptor");
        if (stringArray.length < 6 || stringArray[4].length() != 8) {
            encrypt_pdf.usage();
            return;
        }
        try {
            int n = 0;
            String string = stringArray[4];
            int n2 = 0;
            while (n2 < string.length()) {
                n |= string.charAt(n2) == '0' ? 0 : permit[n2];
                ++n2;
            }
            System.out.println("Reading " + stringArray[0]);
            PdfReader pdfReader = new PdfReader(stringArray[0]);
            System.out.println("Writing " + stringArray[1]);
            PdfEncryptor.encrypt(pdfReader, (OutputStream)new FileOutputStream(stringArray[1]), stringArray[2].getBytes(), stringArray[3].getBytes(), n, stringArray[5].equals("128"));
            System.out.println("Done.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

