/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.pdf.PdfArray;
import clover.com.lowagie.text.pdf.PdfLiteral;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfRectangle;
import clover.com.lowagie.text.pdf.PdfStream;
import clover.com.lowagie.text.pdf.PdfTemplate;

public class PdfFormXObject
extends PdfStream {
    public static final PdfNumber ZERO = new PdfNumber(0);
    public static final PdfNumber ONE = new PdfNumber(1);
    public static final PdfLiteral MATRIX = new PdfLiteral("[1 0 0 1 0 0]");

    PdfFormXObject(PdfTemplate pdfTemplate) {
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.FORM);
        this.put(PdfName.RESOURCES, pdfTemplate.getResources());
        this.put(PdfName.BBOX, new PdfRectangle(pdfTemplate.getBoundingBox()));
        this.put(PdfName.FORMTYPE, ONE);
        PdfArray pdfArray = pdfTemplate.getMatrix();
        if (pdfArray == null) {
            this.put(PdfName.MATRIX, MATRIX);
        } else {
            this.put(PdfName.MATRIX, pdfArray);
        }
        this.bytes = pdfTemplate.toPdf(null);
        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        try {
            this.flateCompress();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

