/*
 * Decompiled with CFR 0.152.
 */
package clover.com.cenqua.util;

public class Radix62 {
    private static final char[] RADIX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final int RADIX = RADIX_DIGITS.length;
    private static final char NEGATIVE = '_';

    public static String encode(long i) {
        boolean negative;
        char[] buf = new char[14];
        int charPos = buf.length - 1;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-RADIX)) {
            buf[charPos--] = RADIX_DIGITS[(int)(-(i % (long)RADIX))];
            i /= (long)RADIX;
        }
        buf[charPos] = RADIX_DIGITS[(int)(-i)];
        if (negative) {
            buf[--charPos] = 95;
        }
        return new String(buf, charPos, buf.length - charPos);
    }

    public static long decode(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("can't decode empty string");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            long limit;
            if (s.charAt(0) == '_') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / (long)RADIX;
            if (i < max) {
                digit = Radix62.findDigit(s.charAt(i++));
                result = -digit;
            }
            while (i < max) {
                digit = Radix62.findDigit(s.charAt(i++));
                if (result < multmin) {
                    throw new IllegalArgumentException(s);
                }
                if ((result *= (long)RADIX) < limit + (long)digit) {
                    throw new IllegalArgumentException(s);
                }
                result -= (long)digit;
            }
        } else {
            throw new IllegalArgumentException(s);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new IllegalArgumentException(s);
        }
        return -result;
    }

    private static int findDigit(char c) {
        for (int i = 0; i < RADIX; ++i) {
            if (RADIX_DIGITS[i] != c) continue;
            return i;
        }
        throw new IllegalArgumentException("String is not in Radix-62 format");
    }
}

