/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.time.chrono;

import clover.cenqua_com_licensing.atlassian.time.Chronology;
import clover.cenqua_com_licensing.atlassian.time.DateTimeField;
import clover.cenqua_com_licensing.atlassian.time.DateTimeZone;
import clover.cenqua_com_licensing.atlassian.time.chrono.AssembledChronology;
import clover.cenqua_com_licensing.atlassian.time.field.LenientDateTimeField;

public final class LenientChronology
extends AssembledChronology {
    private static final long serialVersionUID = -3148237568046877177L;
    private transient Chronology iWithUTC;

    public static LenientChronology getInstance(Chronology chronology) {
        if (chronology == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        return new LenientChronology(chronology);
    }

    private LenientChronology(Chronology chronology) {
        super(chronology, null);
    }

    public Chronology withUTC() {
        if (this.iWithUTC == null) {
            this.iWithUTC = this.getZone() == DateTimeZone.UTC ? this : LenientChronology.getInstance(this.getBase().withUTC());
        }
        return this.iWithUTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == DateTimeZone.UTC) {
            return this.withUTC();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return LenientChronology.getInstance(this.getBase().withZone(dateTimeZone));
    }

    protected void assemble(AssembledChronology.Fields fields) {
        fields.year = LenientChronology.convertField(fields.year);
        fields.yearOfEra = LenientChronology.convertField(fields.yearOfEra);
        fields.yearOfCentury = LenientChronology.convertField(fields.yearOfCentury);
        fields.centuryOfEra = LenientChronology.convertField(fields.centuryOfEra);
        fields.era = LenientChronology.convertField(fields.era);
        fields.dayOfWeek = LenientChronology.convertField(fields.dayOfWeek);
        fields.dayOfMonth = LenientChronology.convertField(fields.dayOfMonth);
        fields.dayOfYear = LenientChronology.convertField(fields.dayOfYear);
        fields.monthOfYear = LenientChronology.convertField(fields.monthOfYear);
        fields.weekOfWeekyear = LenientChronology.convertField(fields.weekOfWeekyear);
        fields.weekyear = LenientChronology.convertField(fields.weekyear);
        fields.weekyearOfCentury = LenientChronology.convertField(fields.weekyearOfCentury);
        fields.millisOfSecond = LenientChronology.convertField(fields.millisOfSecond);
        fields.millisOfDay = LenientChronology.convertField(fields.millisOfDay);
        fields.secondOfMinute = LenientChronology.convertField(fields.secondOfMinute);
        fields.secondOfDay = LenientChronology.convertField(fields.secondOfDay);
        fields.minuteOfHour = LenientChronology.convertField(fields.minuteOfHour);
        fields.minuteOfDay = LenientChronology.convertField(fields.minuteOfDay);
        fields.hourOfDay = LenientChronology.convertField(fields.hourOfDay);
        fields.hourOfHalfday = LenientChronology.convertField(fields.hourOfHalfday);
        fields.clockhourOfDay = LenientChronology.convertField(fields.clockhourOfDay);
        fields.clockhourOfHalfday = LenientChronology.convertField(fields.clockhourOfHalfday);
        fields.halfdayOfDay = LenientChronology.convertField(fields.halfdayOfDay);
    }

    private static final DateTimeField convertField(DateTimeField dateTimeField) {
        return LenientDateTimeField.getInstance(dateTimeField);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LenientChronology)) {
            return false;
        }
        LenientChronology lenientChronology = (LenientChronology)object;
        return this.getBase().equals(lenientChronology.getBase());
    }

    public int hashCode() {
        return 236548278 + this.getBase().hashCode() * 7;
    }

    public String toString() {
        return "LenientChronology[" + this.getBase().toString() + ']';
    }
}

