/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.time.base;

import clover.cenqua_com_licensing.atlassian.time.Chronology;
import clover.cenqua_com_licensing.atlassian.time.DateTimeUtils;
import clover.cenqua_com_licensing.atlassian.time.DateTimeZone;
import clover.cenqua_com_licensing.atlassian.time.ReadableDateTime;
import clover.cenqua_com_licensing.atlassian.time.base.AbstractDateTime;
import clover.cenqua_com_licensing.atlassian.time.chrono.ISOChronology;
import clover.cenqua_com_licensing.atlassian.time.convert.ConverterManager;
import clover.cenqua_com_licensing.atlassian.time.convert.InstantConverter;
import java.io.Serializable;

public abstract class BaseDateTime
extends AbstractDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = -6728882245981L;
    private long iMillis;
    private Chronology iChronology;

    public BaseDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(DateTimeZone dateTimeZone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public BaseDateTime(long l) {
        this(l, (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(long l, DateTimeZone dateTimeZone) {
        this(l, (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(long l, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        this.iMillis = this.checkInstant(l, this.iChronology);
    }

    public BaseDateTime(Object object, DateTimeZone dateTimeZone) {
        Chronology chronology;
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        this.iChronology = chronology = this.checkChronology(instantConverter.getChronology(object, dateTimeZone));
        this.iMillis = this.checkInstant(instantConverter.getInstantMillis(object, chronology), chronology);
    }

    public BaseDateTime(Object object, Chronology chronology) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        this.iChronology = this.checkChronology(instantConverter.getChronology(object, chronology));
        this.iMillis = this.checkInstant(instantConverter.getInstantMillis(object, chronology), this.iChronology);
    }

    public BaseDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5, n6, n7, ISOChronology.getInstance());
    }

    public BaseDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, DateTimeZone dateTimeZone) {
        this(n, n2, n3, n4, n5, n6, n7, ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        long l = this.iChronology.getDateTimeMillis(n, n2, n3, n4, n5, n6, n7);
        this.iMillis = this.checkInstant(l, this.iChronology);
    }

    protected Chronology checkChronology(Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    protected long checkInstant(long l, Chronology chronology) {
        return l;
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setMillis(long l) {
        this.iMillis = this.checkInstant(l, this.iChronology);
    }

    protected void setChronology(Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
    }
}

