#
# Makefile for VIM on the Amiga, using SAS/Lattice C 6.0 to 6.3
#
# Do NOT use the peephole optimizer! It messes up all kinds of things.
# For 6.0 and 6.1, expand_env() will not work correctly.
# For 6.2 and 6.3 the call to free_line in u_freeentry is wrong.
# You should use Manx Aztec C whenever possible.
#
# The prototypes from Manx and SAS are incompatible. If the prototypes
# were generated by Manx, first do "touch *.c; make proto" before "make".
#
# Note: not all dependencies are included. This was done to avoid having
#       to compile everything when a global variable or function is added
#	

#>>>>> choose options:
### DEF=DIGRAPHS		digraph support (at the cost of 1.6 Kbyte code)
### DEF=NO_ARP			do not use arp.library, DOS 2.0 required
### DEF=COMPATIBLE		start in vi-compatible mode
### DEF=NOBACKUP		default is no backup file
### DEF=DEBUG			output a lot of debugging garbage
### DEF=TERMCAP			include termcap file support
### DEF=NO_BUILTIN_TCAPS	do not include builtin termcap entries
###				(use only with -DTERMCAP)
### DEF=SOME_BUILTIN_TCAPS 	include most useful builtin termcap entries
###				(use only without -DNO_BUILTIN_TCAPS)
### DEF=ALL_BUILTIN_TCAPS	include all builtin termcap entries
###				(use only without -DNO_BUILTIN_TCAPS)
DEFINES = DEF=DIGRAPHS DEF=SOME_BUILTIN_TCAPS

#>>>>> if TERMCAP is defined termlib.o has to be used
#TERMLIB = termlib.o
TERMLIB = 

#>>>>> choose NODEBUG for normal compiling, the other for debugging and profiling
# don't switch on debugging when generating proto files, it crashes the compiler.
DBG = NODEBUG
#DBG = DBG=SF

#>>>>> choose NOOPTPEEP for 6.0 to 6.3, NOOPT for debugging
# when all the optimizer bugs are finally solved you can use OPT
#OPTIMIZE=OPT
OPTIMIZE=NOOPTPEEP
#OPTIMIZE=NOOPT

#>>>>> end of choices
###########################################################################

CC = sc
GST = vim.gst
COPTS = SINT SCODE SDATA

CFLAGS = NOLINK $(OPTIMIZE) $(COPTS) DEF=AMIGA DEF=SASC $(DBG) $(DEFINES) GST=$(GST)

PROPT = DEF=PROTO GPROTO GPPARM

OBJ =	alloc.o amiga.o buffers.o charset.o cmdline.o csearch.o digraph.o \
	edit.o fileio.o help.o linefunc.o main.o mark.o message.o misccmds.o \
	normal.o ops.o param.o quickfix.o regexp.o regsub.o screen.o \
	script.o search.o storage.o tag.o term.o undo.o $(TERMLIB)

PRO =	proto/alloc.pro proto/buffers.pro proto/charset.pro proto/cmdline.pro \
	proto/csearch.pro proto/digraph.pro proto/edit.pro proto/fileio.pro \
	proto/help.pro proto/linefunc.pro proto/main.pro proto/mark.pro \
	proto/message.pro proto/misccmds.pro proto/normal.pro proto/ops.pro \
	proto/param.pro proto/quickfix.pro proto/regexp.pro proto/regsub.pro \
	proto/screen.pro proto/script.pro proto/search.pro proto/storage.pro \
	proto/tag.pro proto/term.pro proto/termlib.pro \
	proto/undo.pro proto/amiga.pro

/Vim: $(OBJ) version.c
	$(CC) $(CFLAGS) version.c
	$(CC) LINK $(COPTS) $(OBJ) version.o $(DBG) PNAME=/Vim

debug: $(OBJ) version.c
	$(CC) $(CFLAGS) version.c
	$(CC) LINK $(COPTS) $(OBJ) version.o $(DBG) PNAME=/Vim

proto: $(GST) $(PRO)

ctags:
	csh -c ctags *.c *.h

# can't use delete here, too many file names
clean:
	csh -c rm -f $(OBJ) version.o mkcmdtab.o /Vim $(GST) mkcmdtab

$(GST)  : vim.h keymap.h macros.h ascii.h term.h
	$(CC) $(CFLAGS) MGST=$(GST) vim.h

###########################################################################

alloc.o:	alloc.c  $(GST)
	$(CC) $(CFLAGS) alloc.c

proto/alloc.pro:	alloc.c  $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/alloc.pro $(PROPT) alloc.c

amiga.o:	amiga.c  $(GST)
	$(CC) $(CFLAGS) amiga.c

proto/amiga.pro:	amiga.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/amiga.pro $(PROPT) amiga.c

buffers.o:	buffers.c  $(GST)
	$(CC) $(CFLAGS) buffers.c

proto/buffers.pro:	buffers.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/buffers.pro $(PROPT) buffers.c

charset.o:	charset.c  $(GST)
	$(CC) $(CFLAGS) charset.c

proto/charset.pro:	charset.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/charset.pro $(PROPT) charset.c

cmdline.o:	cmdline.c  $(GST) cmdtab.h
	$(CC) $(CFLAGS) cmdline.c

proto/cmdline.pro:	cmdline.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/cmdline.pro $(PROPT) cmdline.c

csearch.o:	csearch.c  $(GST)
	$(CC) $(CFLAGS) csearch.c

proto/csearch.pro:	csearch.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/csearch.pro $(PROPT) csearch.c

digraph.o:	digraph.c  $(GST)
	$(CC) $(CFLAGS) digraph.c

proto/digraph.pro:	digraph.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/digraph.pro $(PROPT) digraph.c

edit.o:	edit.c  $(GST)
	$(CC) $(CFLAGS) edit.c

proto/edit.pro:	edit.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/edit.pro $(PROPT) edit.c

fileio.o:	fileio.c  $(GST)
	$(CC) $(CFLAGS) fileio.c

proto/fileio.pro:	fileio.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/fileio.pro $(PROPT) fileio.c

help.o:	help.c  $(GST)
	$(CC) $(CFLAGS) help.c

proto/help.pro:	help.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/help.pro $(PROPT) help.c

linefunc.o:	linefunc.c  $(GST)
	$(CC) $(CFLAGS) linefunc.c

proto/linefunc.pro:	linefunc.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/linefunc.pro $(PROPT) linefunc.c

main.o:	main.c  $(GST)
	$(CC) $(CFLAGS) main.c

proto/main.pro:	main.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/main.pro $(PROPT) main.c

mark.o:	mark.c  $(GST) mark.h
	$(CC) $(CFLAGS) mark.c

proto/mark.pro:	mark.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/mark.pro $(PROPT) mark.c

message.o:	message.c  $(GST)
	$(CC) $(CFLAGS) message.c

proto/message.pro:	message.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/message.pro $(PROPT) message.c

misccmds.o:	misccmds.c  $(GST)
	$(CC) $(CFLAGS) misccmds.c

proto/misccmds.pro:	misccmds.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/misccmds.pro $(PROPT) misccmds.c

normal.o:	normal.c  $(GST) ops.h
	$(CC) $(CFLAGS) normal.c

proto/normal.pro:	normal.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/normal.pro $(PROPT) normal.c

ops.o:	ops.c  $(GST) ops.h
	$(CC) $(CFLAGS) ops.c

proto/ops.pro:	ops.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/ops.pro $(PROPT) ops.c

param.o:	param.c  $(GST)
	$(CC) $(CFLAGS) param.c

proto/param.pro:	param.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/param.pro $(PROPT) param.c

quickfix.o:	quickfix.c  $(GST)
	$(CC) $(CFLAGS) quickfix.c

proto/quickfix.pro:	quickfix.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/quickfix.pro $(PROPT) quickfix.c

regexp.o:	regexp.c  $(GST)
	$(CC) $(CFLAGS) regexp.c

proto/regexp.pro:	regexp.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/regexp.pro $(PROPT) regexp.c

regsub.o:	regsub.c  $(GST)
	$(CC) $(CFLAGS) regsub.c

proto/regsub.pro:	regsub.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/regsub.pro $(PROPT) regsub.c

screen.o:	screen.c  $(GST)
	$(CC) $(CFLAGS) screen.c

proto/screen.pro:	screen.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/screen.pro $(PROPT) screen.c

script.o:	script.c  $(GST)
	$(CC) $(CFLAGS) script.c

proto/script.pro:	script.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/script.pro $(PROPT) script.c

search.o:	search.c  $(GST)
	$(CC) $(CFLAGS) search.c

proto/search.pro:	search.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/search.pro $(PROPT) search.c

storage.o:	storage.c  $(GST)
	$(CC) $(CFLAGS) storage.c

proto/storage.pro:	storage.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/storage.pro $(PROPT) storage.c

tag.o:	tag.c  $(GST) mark.h
	$(CC) $(CFLAGS) tag.c

proto/tag.pro:	tag.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/tag.pro $(PROPT) tag.c

term.o:	term.c  $(GST)
	$(CC) $(CFLAGS) term.c

proto/term.pro:	term.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/term.pro $(PROPT) term.c

termlib.o:	termlib.c  $(GST)
	$(CC) $(CFLAGS) termlib.c

proto/termlib.pro:	termlib.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/termlib.pro $(PROPT) termlib.c

undo.o:	undo.c  $(GST)
	$(CC) $(CFLAGS) undo.c

proto/undo.pro:	undo.c $(GST)
	$(CC) $(CFLAGS) GPFILE=proto/undo.pro $(PROPT) undo.c

cmdtab.h: cmdtab.tab mkcmdtab
	mkcmdtab cmdtab.tab cmdtab.h

mkcmdtab.o:	mkcmdtab.c
	$(CC) $(CFLAGS) mkcmdtab.c

mkcmdtab: mkcmdtab.o
	$(CC) LINK $(COPTS) mkcmdtab.o PNAME=mkcmdtab
