/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.Parser;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ParserFrontend {
    private Parser defaulthandler;
    private SAXParserFactory factory;
    private EntityResolver entityResolver;
    private boolean validateDTD;

    protected ParserFrontend(Parser parser) {
        if (parser == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = parser;
    }

    public boolean isValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean bl) {
        this.validateDTD = bl;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            if (this.isValidateDTD()) {
                this.factory.setValidating(true);
            }
        }
        return this.factory.newSAXParser();
    }

    public void setDefaultHandler(Parser parser) {
        if (parser == null) {
            throw new NullPointerException();
        }
        this.defaulthandler = parser;
    }

    public Parser getDefaultHandler() {
        return this.defaulthandler;
    }

    protected Parser createDefaultHandler(URL uRL) {
        Parser parser = this.getDefaultHandler().getInstance();
        if (uRL != null) {
            parser.setConfigProperty("content-base", uRL.toExternalForm());
        }
        return parser;
    }

    protected Object parse(InputSource inputSource, URL uRL) throws ElementDefinitionException {
        try {
            SAXParser sAXParser = this.getParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/validation", this.isValidateDTD());
            Parser parser = this.createDefaultHandler(uRL);
            this.configureReader(xMLReader, parser);
            try {
                xMLReader.setContentHandler(parser);
                xMLReader.setDTDHandler(parser);
                xMLReader.setEntityResolver(this.getEntityResolver());
                xMLReader.setErrorHandler(parser);
                xMLReader.parse(inputSource);
                return parser.getResult();
            }
            catch (IOException iOException) {
                throw new ElementDefinitionException(iOException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ElementDefinitionException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ElementDefinitionException(sAXException);
        }
    }

    protected void configureReader(XMLReader xMLReader, Parser parser) {
    }

    public Object parse(URL uRL, URL uRL2) throws ElementDefinitionException, IOException {
        if (uRL == null) {
            throw new NullPointerException("File may not be null");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(uRL.toString());
        Object object = this.parse(inputSource, uRL2);
        bufferedInputStream.close();
        return object;
    }
}

