/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Week
extends RegularTimePeriod
implements Serializable {
    public static final int FIRST_WEEK_IN_YEAR = 1;
    public static final int LAST_WEEK_IN_YEAR = 53;
    private Year year;
    private int week;

    public Week() {
        this(new Date());
    }

    public Week(int n, int n2) {
        this(n, new Year(n2));
    }

    public Week(int n, Year year) {
        if (n < 1 && n > 53) {
            throw new IllegalArgumentException("Week(...): week outside valid range.");
        }
        this.week = n;
        this.year = year;
    }

    public Week(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Week(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int n = calendar.get(3);
        if (n == 1 && calendar.get(2) == 11) {
            this.week = 1;
            this.year = new Year(calendar.get(1) + 1);
        } else {
            this.week = Math.min(n, 53);
            this.year = new Year(calendar.get(1));
        }
    }

    public Year getYear() {
        return this.year;
    }

    public int getYearValue() {
        return this.year.getYear();
    }

    public int getWeek() {
        return this.week;
    }

    public RegularTimePeriod previous() {
        Week week;
        if (this.week != 1) {
            week = new Week(this.week - 1, this.year);
        } else {
            Year year = (Year)this.year.previous();
            if (year != null) {
                int n = year.getYear();
                Calendar calendar = Calendar.getInstance();
                calendar.set(n, 11, 31);
                week = new Week(calendar.getActualMaximum(3), year);
            } else {
                week = null;
            }
        }
        return week;
    }

    public RegularTimePeriod next() {
        Week week;
        if (this.week < 52) {
            week = new Week(this.week + 1, this.year);
        } else {
            Year year;
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.year.getYear(), 11, 31);
            int n = calendar.getActualMaximum(3);
            week = this.week != n ? new Week(this.week + 1, this.year) : ((year = (Year)this.year.next()) != null ? new Week(1, year) : null);
        }
        return week;
    }

    public long getSerialIndex() {
        return (long)this.year.getYear() * 53L + (long)this.week;
    }

    public long getFirstMillisecond(Calendar calendar) {
        long l = 0L;
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(this.year.getYear(), 0, 1);
        int n = calendar2.get(7);
        calendar2.add(6, 1 - n);
        int n2 = calendar2.get(5);
        int n3 = calendar2.get(2) + 1;
        int n4 = calendar2.get(1);
        SerialDate serialDate = SerialDate.createInstance((int)n2, (int)n3, (int)n4);
        SerialDate serialDate2 = SerialDate.addDays((int)((this.week - 1) * 7), (SerialDate)serialDate);
        Day day = new Day(serialDate2);
        l = day.getFirstMillisecond(calendar);
        return l;
    }

    public long getLastMillisecond(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(this.year.getYear(), 0, 1);
        int n = calendar2.getActualMaximum(3);
        if (this.week == n) {
            return this.year.getLastMillisecond(calendar);
        }
        Calendar calendar3 = Calendar.getInstance();
        calendar3.set(this.year.getYear(), 0, 1);
        int n2 = calendar3.get(7);
        calendar3.add(6, 1 - n2);
        int n3 = calendar3.get(5);
        int n4 = calendar3.get(2) + 1;
        int n5 = calendar3.get(1);
        SerialDate serialDate = SerialDate.createInstance((int)n3, (int)n4, (int)n5);
        SerialDate serialDate2 = SerialDate.addDays((int)(this.week * 7 - 1), (SerialDate)serialDate);
        Day day = new Day(serialDate2);
        return day.getLastMillisecond(calendar);
    }

    public String toString() {
        return "Week " + this.week + ", " + this.year;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Week) {
                Week week = (Week)object;
                return this.week == week.getWeek() && this.year.equals(week.getYear());
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Week) {
            Week week = (Week)object;
            n = this.year.getYear() - week.getYear().getYear();
            if (n == 0) {
                n = this.week - week.getWeek();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Week parseWeek(String string) throws TimePeriodFormatException {
        Week week = null;
        if (string == null) return week;
        int n = Week.findSeparator(string = string.trim());
        if (n == -1) throw new TimePeriodFormatException("Week.parseWeek(String): could not find separator.");
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, string.length()).trim();
        Year year = Week.evaluateAsYear(string2);
        if (year != null) {
            int n2 = Week.stringToWeek(string3);
            if (n2 != -1) return new Week(n2, year);
            throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
        }
        year = Week.evaluateAsYear(string3);
        if (year == null) throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the year.");
        int n3 = Week.stringToWeek(string2);
        if (n3 != -1) return new Week(n3, year);
        throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
    }

    private static int findSeparator(String string) {
        int n = -1;
        n = string.indexOf(45);
        if (n == -1) {
            n = string.indexOf(44);
        }
        if (n == -1) {
            n = string.indexOf(32);
        }
        if (n == -1) {
            n = string.indexOf(46);
        }
        return n;
    }

    private static Year evaluateAsYear(String string) {
        Year year = null;
        try {
            year = Year.parseYear(string);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {}
        return year;
    }

    private static int stringToWeek(String string) {
        int n = -1;
        string = string.replace('W', ' ');
        string = string.trim();
        try {
            n = Integer.parseInt(string);
            if (n < 1 || n > 53) {
                n = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }
}

