/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private double margin;
    private double translatedRangeZero;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double d, boolean bl) {
        super(d);
        this.margin = d;
        this.centerBarAtStartValue = bl;
    }

    public int initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, chartRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.translatedRangeZero = valueAxis.translateValueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        return 1;
    }

    public void setMargin(double d) {
        this.margin = d;
        super.setMargin(d);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        EntityCollection entityCollection;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2);
        Paint paint2 = this.getItemOutlinePaint(n, n2);
        double d = intervalXYDataset.getYValue(n, n2).doubleValue();
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d2 = valueAxis2.translateValueToJava2D(d, rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.getDomainAxisEdge();
        double d3 = intervalXYDataset.getStartXValue(n, n2).doubleValue();
        double d4 = valueAxis.translateValueToJava2D(d3, rectangle2D, rectangleEdge2);
        double d5 = intervalXYDataset.getEndXValue(n, n2).doubleValue();
        double d6 = valueAxis.translateValueToJava2D(d5, rectangle2D, rectangleEdge2);
        double d7 = Math.max(1.0, Math.abs(d6 - d4));
        double d8 = Math.abs(d2 - this.translatedRangeZero);
        if (this.centerBarAtStartValue) {
            d4 -= d7 / 2.0;
        }
        if (this.margin > 0.0) {
            double d9 = d7 * this.margin;
            d7 -= d9;
            d4 += d9 / 2.0;
        }
        int n4 = xYDataset.getSeriesCount();
        double d10 = d7 / (double)n4;
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(this.translatedRangeZero, d2), d4 - d10 * (double)(n4 - n), d8, d10);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d4 + d10 * (double)n, Math.min(this.translatedRangeZero, d2), d10, d8);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (Math.abs(d6 - d4) > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (chartRenderingInfo != null && (entityCollection = chartRenderingInfo.getEntityCollection()) != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

