/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItem;
import org.jfree.chart.Marker;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Range;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectList;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer,
Cloneable,
Serializable {
    private CategoryPlot plot;
    private CategoryItemLabelGenerator itemLabelGenerator = null;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private CategoryItemLabelGenerator baseItemLabelGenerator;
    private CategoryURLGenerator itemURLGenerator = null;
    private ObjectList itemURLGeneratorList = new ObjectList();
    private CategoryURLGenerator baseItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;
    private double itemLabelAnchorOffset = 2.0;

    protected AbstractCategoryItemRenderer() {
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setPlot(CategoryPlot categoryPlot) {
        this.plot = categoryPlot;
    }

    public CategoryItemLabelGenerator getItemLabelGenerator(int n, int n2) {
        return this.getSeriesItemLabelGenerator(n);
    }

    public CategoryItemLabelGenerator getSeriesItemLabelGenerator(int n) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        CategoryItemLabelGenerator categoryItemLabelGenerator = (CategoryItemLabelGenerator)this.itemLabelGeneratorList.get(n);
        if (categoryItemLabelGenerator == null) {
            categoryItemLabelGenerator = this.baseItemLabelGenerator;
        }
        return categoryItemLabelGenerator;
    }

    public void setItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGenerator = categoryItemLabelGenerator;
    }

    public void setSeriesItemLabelGenerator(int n, CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGeneratorList.set(n, (Object)categoryItemLabelGenerator);
    }

    public CategoryItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.baseItemLabelGenerator = categoryItemLabelGenerator;
    }

    public CategoryURLGenerator getItemURLGenerator(int n, int n2) {
        return this.getSeriesItemURLGenerator(n);
    }

    public CategoryURLGenerator getSeriesItemURLGenerator(int n) {
        if (this.itemURLGenerator != null) {
            return this.itemURLGenerator;
        }
        CategoryURLGenerator categoryURLGenerator = (CategoryURLGenerator)this.itemURLGeneratorList.get(n);
        if (categoryURLGenerator == null) {
            categoryURLGenerator = this.baseItemURLGenerator;
        }
        return categoryURLGenerator;
    }

    public void setItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGenerator = categoryURLGenerator;
    }

    public void setSeriesItemURLGenerator(int n, CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGeneratorList.set(n, (Object)categoryURLGenerator);
    }

    public CategoryURLGenerator getBaseItemURLGenerator() {
        return this.baseItemURLGenerator;
    }

    public void setBaseItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.baseItemURLGenerator = categoryURLGenerator;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, Integer n, ChartRenderingInfo chartRenderingInfo) {
        this.setPlot(categoryPlot);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            this.rowCount = categoryDataset.getRowCount();
            this.columnCount = categoryDataset.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        this.setInfo(chartRenderingInfo);
    }

    public RangeType getRangeType() {
        return RangeType.STANDARD;
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawBackground(graphics2D, rectangle2D);
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawOutline(graphics2D, rectangle2D);
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        Line2D.Double double_ = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = marker.getOutlinePaint();
        if (paint == null) {
            paint = Plot.DEFAULT_OUTLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = marker.getOutlineStroke();
        if (stroke == null) {
            stroke = Plot.DEFAULT_OUTLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        CategoryDataset categoryDataset = n == 0 ? categoryPlot.getDataset() : categoryPlot.getSecondaryDataset(n - 1);
        String string2 = string = categoryDataset.getRowKey(n2).toString();
        Shape shape = this.getSeriesShape(n2);
        Paint paint = this.getSeriesPaint(n2);
        Paint paint2 = this.getSeriesOutlinePaint(n2);
        Stroke stroke = this.getSeriesStroke(n2);
        return new LegendItem(string, string2, shape, paint, paint2, stroke);
    }

    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (object instanceof AbstractCategoryItemRenderer) {
            AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)object;
            if (this.baseItemLabelGenerator != null) {
                bl = bl && this.baseItemLabelGenerator.equals(abstractCategoryItemRenderer.getBaseItemLabelGenerator());
            } else {
                boolean bl2 = bl = bl && abstractCategoryItemRenderer.getBaseItemLabelGenerator() == null;
            }
            bl = this.itemURLGenerator != null ? bl && this.itemURLGenerator.equals(abstractCategoryItemRenderer.itemURLGenerator) : bl && abstractCategoryItemRenderer.itemURLGenerator == null;
        }
        return bl;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot != null) {
            drawingSupplier = categoryPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, CategoryDataset categoryDataset, int n, int n2, double d, double d2, boolean bl) {
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (categoryItemLabelGenerator != null) {
            Font font = this.getItemLabelFont(n, n2);
            graphics2D.setFont(font);
            Paint paint = this.getItemLabelPaint(n, n2);
            graphics2D.setPaint(paint);
            String string = categoryItemLabelGenerator.generateItemLabel(categoryDataset, n, n2);
            ItemLabelAnchor itemLabelAnchor = this.getItemLabelAnchor(n, n2);
            TextAnchor textAnchor = this.getItemLabelTextAnchor(n, n2);
            TextAnchor textAnchor2 = this.getItemLabelRotationAnchor(n, n2);
            if (bl) {
                itemLabelAnchor = ItemLabelAnchor.getVerticalOpposite(itemLabelAnchor);
                textAnchor = TextAnchor.getVerticalOpposite((TextAnchor)textAnchor);
                textAnchor2 = TextAnchor.getVerticalOpposite((TextAnchor)textAnchor2);
            }
            double d3 = this.getItemLabelAngle(n, n2).doubleValue();
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelAnchor, d, d2, plotOrientation);
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)textAnchor, (TextAnchor)textAnchor2, (double)d3);
        }
    }

    private Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, double d, double d2, PlotOrientation plotOrientation) {
        Point2D point2D = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            point2D = this.getHorizontalLabelAnchorPoint(itemLabelAnchor, d2, d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            point2D = this.getVerticalLabelAnchorPoint(itemLabelAnchor, d, d2);
        }
        return point2D;
    }

    private Point2D getHorizontalLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, double d, double d2) {
        Point2D.Double double_ = null;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d, d2 + this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d - this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d, d2 - this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d + this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d, d2 + 2.0 * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d - 2.0 * this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d, d2 - 2.0 * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d + 2.0 * this.itemLabelAnchorOffset, d2);
        }
        return double_;
    }

    private Point2D getVerticalLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, double d, double d2) {
        Point2D.Double double_ = null;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d + this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d, d2 + this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d - this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d, d2 - this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d + 2.0 * this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d, d2 + 2.0 * this.itemLabelAnchorOffset);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d - 2.0 * this.itemLabelAnchorOffset, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d, d2);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d, d2 - 2.0 * this.itemLabelAnchorOffset);
        }
        return double_;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)super.clone();
        if (this.itemLabelGenerator != null) {
            abstractCategoryItemRenderer.itemLabelGenerator = (CategoryItemLabelGenerator)this.itemLabelGenerator.clone();
        }
        if (this.itemLabelGeneratorList != null) {
            abstractCategoryItemRenderer.itemLabelGeneratorList = (ObjectList)this.itemLabelGeneratorList.clone();
        }
        if (this.baseItemLabelGenerator != null) {
            abstractCategoryItemRenderer.baseItemLabelGenerator = (CategoryItemLabelGenerator)this.baseItemLabelGenerator.clone();
        }
        if (this.itemURLGenerator != null) {
            abstractCategoryItemRenderer.itemURLGenerator = (CategoryURLGenerator)this.itemURLGenerator.clone();
        }
        if (this.itemURLGeneratorList != null) {
            abstractCategoryItemRenderer.itemURLGeneratorList = (ObjectList)this.itemURLGeneratorList.clone();
        }
        if (this.baseItemURLGenerator != null) {
            abstractCategoryItemRenderer.baseItemURLGenerator = (CategoryURLGenerator)this.baseItemURLGenerator.clone();
        }
        return abstractCategoryItemRenderer;
    }

    protected CategoryAxis getDomainAxis(CategoryPlot categoryPlot, Integer n) {
        CategoryAxis categoryAxis = null;
        if (n == null) {
            categoryAxis = categoryPlot.getDomainAxis();
        } else {
            categoryAxis = categoryPlot.getSecondaryDomainAxis(n);
            if (categoryAxis == null) {
                categoryAxis = categoryPlot.getDomainAxis();
            }
        }
        return categoryAxis;
    }

    protected ValueAxis getRangeAxis(CategoryPlot categoryPlot, Integer n) {
        ValueAxis valueAxis = null;
        if (n == null) {
            valueAxis = categoryPlot.getRangeAxis();
        } else {
            valueAxis = categoryPlot.getSecondaryRangeAxis(n);
            if (valueAxis == null) {
                valueAxis = categoryPlot.getRangeAxis();
            }
        }
        return valueAxis;
    }

    protected CategoryDataset getDataset(CategoryPlot categoryPlot, Integer n) {
        CategoryDataset categoryDataset = null;
        categoryDataset = n == null ? categoryPlot.getDataset() : categoryPlot.getSecondaryDataset(n);
        return categoryDataset;
    }
}

