/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ArrayUtils;
import org.jfree.util.ObjectUtils;

public class FastScatterPlot
extends Plot
implements ValueAxisPlot,
Cloneable,
Serializable {
    private float[][] data;
    private Range xDataRange;
    private Range yDataRange;
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private transient Paint paint;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public FastScatterPlot() {
        this(null, null, null);
    }

    public FastScatterPlot(float[][] fArray, ValueAxis valueAxis, ValueAxis valueAxis2) {
        this.data = fArray;
        this.xDataRange = this.calculateXDataRange(fArray);
        this.yDataRange = this.calculateYDataRange(fArray);
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.paint = Color.red;
    }

    public String getPlotType() {
        return localizationResources.getString("Fast_Scatter_Plot");
    }

    public ValueAxis getDomainAxis() {
        return this.domainAxis;
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        double d;
        Insets insets;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.BOTTOM, axisSpace);
        axisSpace = this.rangeAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.LEFT, axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        if (this.domainAxis != null) {
            d = rectangle2D2.getMaxY();
            d = this.domainAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM);
        }
        if (this.rangeAxis != null) {
            d = rectangle2D2.getMinX();
            d = this.rangeAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.LEFT);
        }
        Shape shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.render(graphics2D, rectangle2D2, chartRenderingInfo, null);
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        graphics2D.setPaint(Color.red);
        if (this.data != null) {
            int n = 0;
            while (n < this.data[0].length) {
                float f = this.data[0][n];
                float f2 = this.data[1][n];
                int n2 = (int)this.domainAxis.translateValueToJava2D(f, rectangle2D, RectangleEdge.BOTTOM);
                int n3 = (int)this.rangeAxis.translateValueToJava2D(f2, rectangle2D, RectangleEdge.LEFT);
                graphics2D.fillRect(n2, n3, 1, 1);
                ++n;
            }
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (valueAxis == this.domainAxis) {
            range = this.xDataRange;
        } else if (valueAxis == this.rangeAxis) {
            range = this.yDataRange;
        }
        return range;
    }

    private Range calculateXDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            int n = 0;
            while (n < fArray[0].length) {
                float f3 = fArray[0][n];
                if (f3 < f) {
                    f = f3;
                }
                if (f3 > f2) {
                    f2 = f3;
                }
                ++n;
            }
            if (f <= f2) {
                range = new Range(f, f2);
            }
        }
        return range;
    }

    private Range calculateYDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            int n = 0;
            while (n < fArray[0].length) {
                float f3 = fArray[1][n];
                if (f3 < f) {
                    f = f3;
                }
                if (f3 > f2) {
                    f2 = f3;
                }
                ++n;
            }
            if (f <= f2) {
                range = new Range(f, f2);
            }
        }
        return range;
    }

    public void zoomHorizontalAxes(double d) {
    }

    public void zoomHorizontalAxes(double d, double d2) {
    }

    public void zoomVerticalAxes(double d) {
    }

    public void zoomVerticalAxes(double d, double d2) {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof FastScatterPlot) {
            FastScatterPlot fastScatterPlot = (FastScatterPlot)object;
            boolean bl = ArrayUtils.equal((float[][])this.data, (float[][])fastScatterPlot.data);
            boolean bl2 = ObjectUtils.equal((Object)this.domainAxis, (Object)fastScatterPlot.domainAxis);
            boolean bl3 = ObjectUtils.equal((Object)this.rangeAxis, (Object)fastScatterPlot.rangeAxis);
            boolean bl4 = ObjectUtils.equal((Object)this.paint, (Object)fastScatterPlot.paint);
            return bl && bl2 && bl3 && bl4;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        FastScatterPlot fastScatterPlot = (FastScatterPlot)super.clone();
        if (this.data != null) {
            fastScatterPlot.data = ArrayUtils.clone((float[][])this.data);
        }
        if (this.domainAxis != null) {
            fastScatterPlot.domainAxis = (ValueAxis)this.domainAxis.clone();
        }
        if (this.rangeAxis != null) {
            fastScatterPlot.rangeAxis = (ValueAxis)this.rangeAxis.clone();
        }
        return fastScatterPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        if (this.domainAxis != null) {
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.addChangeListener(this);
        }
    }
}

