/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 8131981331486016455L;
    ListModel _list;
    Object _selected = null;
    Logger _logger = Logger.getLogger(this.getClass().getName());

    public ListComboBoxModel(ListModel list) {
        this._list = list;
        this._list.addListDataListener(new MyListener());
    }

    public Object getElementAt(int index) {
        return this._list.getElementAt(index);
    }

    public Object getSelectedItem() {
        return this._selected;
    }

    public int getSize() {
        return this._list.getSize();
    }

    public void setSelectedItem(Object anItem) {
        if (this._selected == null && anItem == null) {
            return;
        }
        if (this._selected == null && anItem != null || this._selected != null && anItem == null || !this._selected.equals(anItem)) {
            this._selected = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public static void main(String[] argList) {
        JFrame top = new JFrame("ListComboBoxTest");
        final DefaultListModel<String> dlm = new DefaultListModel<String>();
        final ListComboBoxModel lcbm = new ListComboBoxModel(dlm);
        lcbm.addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent evt) {
                System.err.println("Interval Removed : " + evt);
            }

            public void intervalAdded(ListDataEvent evt) {
                System.err.println("Interval Added : " + evt);
            }

            public void contentsChanged(ListDataEvent evt) {
                System.err.println("ContentsChanged: " + evt);
            }
        });
        dlm.addElement("a");
        dlm.addElement("b");
        dlm.addElement("c");
        dlm.addElement("d");
        JComboBox jcb = new JComboBox(lcbm);
        jcb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.err.println("Event : " + evt.paramString());
            }
        });
        top.getContentPane().setLayout(new BorderLayout());
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        top.getContentPane().add(jcb, "North");
        JButton clear = new JButton("CLEAR");
        top.getContentPane().add((Component)clear, "South");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                dlm.clear();
                System.err.println("DLM size = " + dlm.size());
                System.err.println("Selected item = " + lcbm.getSelectedItem());
            }
        });
        JButton select = new JButton("SELECT");
        top.getContentPane().add((Component)select, "West");
        select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                lcbm.setSelectedItem(lcbm.getElementAt(0));
                System.err.println("Selected " + lcbm.getSelectedItem());
            }
        });
        top.pack();
        top.setVisible(true);
    }

    private class MyListener
    implements ListDataListener {
        private MyListener() {
        }

        public void contentsChanged(ListDataEvent e) {
            ListComboBoxModel.this.fireContentsChanged(ListComboBoxModel.this, e.getIndex0(), e.getIndex1());
            ListComboBoxModel.this.setSelectedItem(null);
        }

        public void intervalAdded(ListDataEvent e) {
            ListComboBoxModel.this.fireIntervalAdded(ListComboBoxModel.this, e.getIndex0(), e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
            ListComboBoxModel.this.fireIntervalRemoved(ListComboBoxModel.this, e.getIndex0(), e.getIndex1());
            if (ListComboBoxModel.this._selected == null) {
                return;
            }
            int size = ListComboBoxModel.this.getSize();
            for (int i = 0; i < size; ++i) {
                Object item = ListComboBoxModel.this.getElementAt(i);
                if (item == null || !item.equals(ListComboBoxModel.this._selected)) continue;
                return;
            }
            ListComboBoxModel.this.setSelectedItem(null);
        }
    }
}

