/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.owasp.webscarab.util.swing.DocumentOutputStream;

public class ExceptionHandler
extends JDialog {
    private static final long serialVersionUID = 7592992184923087071L;
    private static Frame _parent = null;
    private static boolean _disabled = false;
    private JCheckBox disableCheckBox;
    private JTextArea exceptionTextArea;
    private JScrollPane jScrollPane1;
    private JButton okButton;

    public ExceptionHandler() {
        super(_parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public static void setParentComponent(Component component) {
        _parent = null;
        while (component != null && component.getParent() != null) {
            component = component.getParent();
        }
        if (component != null && component instanceof Frame) {
            _parent = (Frame)component;
        }
    }

    public void handle(Throwable t) {
        System.setProperty("sun.awt.exception.handler", "");
        t.printStackTrace();
        if (_disabled) {
            return;
        }
        DocumentOutputStream dos = new DocumentOutputStream();
        t.printStackTrace(new PrintStream(dos));
        this.exceptionTextArea.setDocument(dos.getDocument());
        this.setVisible(true);
        if (!this.disableCheckBox.isSelected()) {
            System.setProperty("sun.awt.exception.handler", this.getClass().getName());
        } else {
            _disabled = true;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.exceptionTextArea = new JTextArea();
        this.disableCheckBox = new JCheckBox();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setPreferredSize(new Dimension(600, 300));
        this.exceptionTextArea.setBackground(new Color(204, 204, 204));
        this.exceptionTextArea.setEditable(false);
        this.jScrollPane1.setViewportView(this.exceptionTextArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.disableCheckBox.setMnemonic('S');
        this.disableCheckBox.setText("Stop displaying exceptions");
        this.getContentPane().add((Component)this.disableCheckBox, "North");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExceptionHandler.this.okButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.okButton, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        System.setProperty("sun.awt.exception.handler", ExceptionHandler.class.getName());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                throw new RuntimeException("blah");
            }
        });
    }
}

