/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DocumentOutputStream
extends OutputStream {
    PlainDocument _doc = new PlainDocument();
    private int _max;

    public DocumentOutputStream() {
        this(Integer.MAX_VALUE);
    }

    public DocumentOutputStream(int max) {
        this._max = max;
    }

    public Document getDocument() {
        return this._doc;
    }

    private void makeSpace(int count) {
        int length = this._doc.getLength();
        if (length + count < this._max) {
            return;
        }
        try {
            if (count > this._max) {
                this._doc.remove(0, length);
            } else {
                int min = length + count - this._max;
                String remove = this._doc.getText(min, Math.min(500, length - min));
                int cr = remove.indexOf("\n");
                min = cr < 0 ? (min += remove.length()) : Math.min(min + cr + 1, length);
                this._doc.remove(0, min);
            }
        }
        catch (BadLocationException ble) {
            System.err.println("BLE! " + ble);
        }
    }

    public void write(int b) throws IOException {
        try {
            this.makeSpace(1);
            this._doc.insertString(this._doc.getLength(), new String(new byte[]{(byte)(b & 0xFF)}, "ISO-8859-1"), null);
        }
        catch (BadLocationException ble) {
            throw new IOException(ble.getMessage());
        }
    }

    public void write(byte[] buff) throws IOException {
        this.write(buff, 0, buff.length);
    }

    public void write(byte[] buff, int off, int length) throws IOException {
        try {
            this.makeSpace(length);
            this._doc.insertString(this._doc.getLength(), new String(buff, off, length, "ISO-8859-1"), null);
        }
        catch (BadLocationException ble) {
            throw new IOException(ble.getMessage());
        }
    }
}

