/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class RegexExpansion {
    private String regex;
    private int size = 0;
    private int index = 0;
    private char[][] charsets;

    public RegexExpansion(String regex) throws PatternSyntaxException {
        int i;
        this.regex = regex;
        LinkedList charsets = new LinkedList();
        List<Character> chars = new LinkedList<Character>();
        boolean inClass = false;
        boolean quoted = false;
        String quantifier = null;
        char range = '\u0000';
        block10: for (int index = 0; index < regex.length(); ++index) {
            char ch = regex.charAt(index);
            if (!(quoted || inClass || ch != '.' && ch != '*' && ch != '?')) {
                throw new PatternSyntaxException("No wildcards permitted", regex, index);
            }
            if (quantifier != null && ch != '}') {
                if (!Character.isDigit(ch)) {
                    throw new PatternSyntaxException("Illegal non-digit character in quantifier", regex, index);
                }
                quantifier = quantifier + ch;
                continue;
            }
            if (quoted) {
                chars.add(new Character(ch));
                quoted = false;
            } else {
                switch (ch) {
                    case '[': {
                        inClass = true;
                        continue block10;
                    }
                    case ']': {
                        inClass = false;
                        break;
                    }
                    case '\\': {
                        quoted = true;
                        continue block10;
                    }
                    case '{': {
                        if (charsets.size() == 0) {
                            throw new PatternSyntaxException("Illegal quantifier at start of regex", regex, index);
                        }
                        quantifier = "";
                        continue block10;
                    }
                    case '}': {
                        try {
                            int c = Integer.parseInt(quantifier);
                            if (c == 0) {
                                throw new PatternSyntaxException("Cannot repeat 0 times", regex, index);
                            }
                            for (int i2 = 1; i2 < c; ++i2) {
                                charsets.add(charsets.get(charsets.size() - 1));
                            }
                        }
                        catch (NumberFormatException nfe) {
                            throw new PatternSyntaxException(nfe.getMessage(), regex, index);
                        }
                        quantifier = null;
                        continue block10;
                    }
                    case '-': {
                        if (inClass) {
                            range = ((Character)chars.get(chars.size() - 1)).charValue();
                            continue block10;
                        }
                    }
                    default: {
                        if (range != '\u0000') {
                            if (ch <= range) {
                                throw new PatternSyntaxException("Illegal range definition", regex, index);
                            }
                            for (char q = range = (char)(range + '\u0001'); q <= ch; q = (char)(q + '\u0001')) {
                                chars.add(new Character(q));
                            }
                            range = '\u0000';
                            break;
                        }
                        chars.add(new Character(ch));
                    }
                }
            }
            if (inClass) continue;
            charsets.add(chars);
            chars = new LinkedList();
        }
        this.charsets = new char[charsets.size()][];
        for (i = 0; i < charsets.size(); ++i) {
            chars = (List)charsets.get(i);
            char[] t = new char[chars.size()];
            for (int j = 0; j < chars.size(); ++j) {
                t[j] = ((Character)chars.get(j)).charValue();
            }
            this.charsets[i] = t;
        }
        this.size = 1;
        for (i = 0; i < this.charsets.length; ++i) {
            this.size *= this.charsets[i].length;
            if (this.size != 0) continue;
            throw new PatternSyntaxException("Pattern expansion overflow at position " + i, regex, 0);
        }
    }

    protected RegexExpansion(RegexExpansion re) {
        this.regex = re.regex;
        this.charsets = re.charsets;
        this.size = re.size;
        this.index = 0;
    }

    public String getRegex() {
        return this.regex;
    }

    public int size() {
        return this.size;
    }

    public void setIndex(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.size);
        }
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasNext() {
        return this.getIndex() < this.size();
    }

    public String next() {
        if (this.index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds: " + this.index + " >= " + this.size);
        }
        return this.get(this.index++);
    }

    public String get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.size);
        }
        StringBuffer buff = new StringBuffer(this.charsets.length);
        for (int i = this.charsets.length - 1; i >= 0; --i) {
            int mod = index % this.charsets[i].length;
            index /= this.charsets[i].length;
            buff.insert(0, this.charsets[i][mod]);
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        RegexExpansion re = new RegexExpansion("[0-9A-F]{8}");
        System.out.println("Size " + re.size());
    }
}

