/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LevenshteinDistance {
    private List _baseline;
    private int[] _current;
    private int[] _previous;

    public LevenshteinDistance(List baseline) {
        this._baseline = baseline;
        this._current = new int[this._baseline.size() + 1];
        this._previous = new int[this._baseline.size() + 1];
    }

    public synchronized int getDistance(List target) {
        if (this._baseline.size() == 0) {
            return target.size();
        }
        if (target.size() == 0) {
            return this._baseline.size();
        }
        for (int i = 0; i < this._current.length; ++i) {
            this._current[i] = i;
        }
        Iterator targIt = target.iterator();
        int j = 0;
        while (targIt.hasNext()) {
            Object targObj = targIt.next();
            ++j;
            int[] t = this._previous;
            this._previous = this._current;
            this._current = t;
            this._current[0] = this._previous[0] + 1;
            Iterator baseIt = this._baseline.iterator();
            int i = 0;
            while (baseIt.hasNext()) {
                Object baseObj = baseIt.next();
                int cost = baseObj.equals(targObj) ? 0 : 1;
                this._current[++i] = Math.min(Math.min(this._previous[i] + 1, this._current[i - 1] + 1), this._previous[i - 1] + cost);
            }
        }
        return this._current[this._baseline.size()];
    }

    public static void main(String[] args) {
        ArrayList<Character> baseline = new ArrayList<Character>();
        baseline.add(new Character('l'));
        baseline.add(new Character('e'));
        baseline.add(new Character('v'));
        baseline.add(new Character('e'));
        baseline.add(new Character('n'));
        baseline.add(new Character('s'));
        baseline.add(new Character('h'));
        baseline.add(new Character('t'));
        baseline.add(new Character('e'));
        LevenshteinDistance ld = new LevenshteinDistance(baseline);
        ArrayList<Character> target = new ArrayList<Character>();
        target.add(new Character('m'));
        target.add(new Character('e'));
        target.add(new Character('i'));
        target.add(new Character('l'));
        target.add(new Character('e'));
        target.add(new Character('n'));
        target.add(new Character('s'));
        target.add(new Character('t'));
        target.add(new Character('e'));
        int distance = ld.getDistance(target);
        System.out.println("Distance between \"meilenstein\" and \"levenshtein\": " + distance);
    }
}

