/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMHandler
implements ContentHandler,
LexicalHandler {
    private Document _document = null;
    private Stack _stack = new Stack();
    private Node _last = null;
    private List _namespaces = null;
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String XMLNS_STRING = "xmlns:";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    public DOMHandler() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        this._document = builder.newDocument();
    }

    public Document getDocument() {
        return this._document;
    }

    public void characters(char[] ch, int start, int length) {
        Node last = (Node)this._stack.peek();
        if (last != this._document) {
            String text = new String(ch, start, length);
            if (this._last != null && this._last.getNodeType() == 3) {
                ((Text)this._last).appendData(text);
            } else {
                this._last = last.appendChild(this._document.createTextNode(text));
            }
        }
    }

    public void startDocument() {
        this._stack.push(this._document);
    }

    public void endDocument() {
        this._stack.pop();
    }

    public void startElement(String namespace, String localName, String qName, Attributes attrs) {
        Element element = this._document.createElementNS(namespace, qName);
        if (this._namespaces != null) {
            for (int i = 0; i < this._namespaces.size(); ++i) {
                String prefix;
                if ((prefix = (String)this._namespaces.get(i++)) == null || prefix.equals("")) {
                    element.setAttributeNS(XMLNS_URI, XMLNS_PREFIX, (String)this._namespaces.get(i));
                    continue;
                }
                element.setAttributeNS(XMLNS_URI, XMLNS_STRING + prefix, (String)this._namespaces.get(i));
            }
            this._namespaces.clear();
        }
        int nattrs = attrs.getLength();
        for (int i = 0; i < nattrs; ++i) {
            if (attrs.getLocalName(i) == null) {
                element.setAttribute(attrs.getQName(i), attrs.getValue(i));
                continue;
            }
            element.setAttributeNS(attrs.getURI(i), attrs.getQName(i), attrs.getValue(i));
        }
        Node last = (Node)this._stack.peek();
        last.appendChild(element);
        this._stack.push(element);
        this._last = null;
    }

    public void endElement(String namespace, String localName, String qName) {
        this._stack.pop();
        this._last = null;
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this._namespaces == null) {
            this._namespaces = new ArrayList();
        }
        this._namespaces.add(prefix);
        this._namespaces.add(uri);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
        Node last = (Node)this._stack.peek();
        ProcessingInstruction pi = this._document.createProcessingInstruction(target, data);
        if (pi != null) {
            last.appendChild(pi);
            this._last = pi;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void comment(char[] ch, int start, int length) {
        Node last = (Node)this._stack.peek();
        Comment comment = this._document.createComment(new String(ch, start, length));
        if (comment != null) {
            last.appendChild(comment);
            this._last = comment;
        }
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startEntity(String name) {
    }

    public void endDTD() {
    }

    public void endEntity(String name) {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }
}

