/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.util.Encoding;

public class UrlEncodedPanel
extends JPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = -3833312254718210891L;
    private static final ColumnWidthTracker _cwt = ColumnWidthTracker.getTracker("UrlEncoded");
    private boolean _editable = false;
    private boolean _modified = false;
    private NamedValueTableModel _tableModel;
    private String _data = null;
    private List _values = new ArrayList();
    private JPanel buttonPanel;
    private JButton deleteButton;
    private JTable headerTable;
    private JButton insertButton;
    private JScrollPane jScrollPane1;

    public UrlEncodedPanel() {
        this.initComponents();
        this.setName("URLEncoded");
        this._tableModel = new NamedValueTableModel();
        this.headerTable.setModel(this._tableModel);
        this.setEditable(this._editable);
        _cwt.addTable(this.headerTable);
    }

    public String[] getContentTypes() {
        return new String[]{"application/x-www-form-urlencoded"};
    }

    public void setBytes(String contentType, byte[] bytes) {
        this._values.clear();
        if (bytes == null) {
            this._data = null;
        } else {
            try {
                this._data = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            NamedValue[] values = NamedValue.splitNamedValues(this._data, "&", "=");
            for (int i = 0; i < values.length; ++i) {
                String name = Encoding.urlDecode(values[i].getName());
                String value = Encoding.urlDecode(values[i].getValue());
                values[i] = new NamedValue(name, value);
                this._values.add(values[i]);
            }
        }
        this._tableModel.fireTableDataChanged();
        this._modified = false;
    }

    public byte[] getBytes() {
        if (this._editable && this.isModified()) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this._values.size(); ++i) {
                NamedValue value = (NamedValue)this._values.get(i);
                if (value.getName() == null || value.getName().equals("")) continue;
                if (i > 0) {
                    buff.append("&");
                }
                buff.append(Encoding.urlEncode(value.getName())).append("=");
                if (value.getValue() == null) continue;
                buff.append(Encoding.urlEncode(value.getValue()));
            }
            this._data = buff.toString();
        }
        if (this._data == null) {
            return new byte[0];
        }
        try {
            return this._data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this.buttonPanel.setVisible(this._editable);
        Color color = this._editable ? Color.WHITE : new Color(204, 204, 204);
        this.headerTable.setBackground(color);
    }

    public boolean isModified() {
        if (this.headerTable.isEditing()) {
            this.headerTable.getCellEditor().stopCellEditing();
        }
        return this._editable && this._modified;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.headerTable = new JTable();
        this.buttonPanel = new JPanel();
        this.insertButton = new JButton();
        this.deleteButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(402, 50));
        this.jScrollPane1.setMinimumSize(new Dimension(200, 50));
        this.headerTable.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView(this.headerTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.insertButton.setText("Insert");
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlEncodedPanel.this.insertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.buttonPanel.add((Component)this.insertButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlEncodedPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.buttonPanel.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    public void insertRow(int row) {
        this._values.add(row, new NamedValue("Variable", "value"));
        this._modified = true;
        this._tableModel.fireTableRowsInserted(row, row);
    }

    public void removeRow(int row) {
        this._values.remove(row);
        this._modified = true;
        this._tableModel.fireTableRowsDeleted(row, row);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.headerTable.getSelectedRow();
        if (rowIndex > -1) {
            this.removeRow(rowIndex);
        }
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.headerTable.getSelectedRow();
        if (rowIndex > -1) {
            this.insertRow(rowIndex);
        } else {
            this.insertRow(this._tableModel.getRowCount());
        }
    }

    private class NamedValueTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4167541370824350945L;
        private String[] _names = new String[]{"Variable", "Value"};

        private NamedValueTableModel() {
        }

        public String getColumnName(int column) {
            return this._names[column];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return UrlEncodedPanel.this._values.size();
        }

        public Object getValueAt(int row, int column) {
            if (row > UrlEncodedPanel.this._values.size() - 1) {
                return "ERROR";
            }
            NamedValue nv = (NamedValue)UrlEncodedPanel.this._values.get(row);
            if (column == 0) {
                return nv.getName();
            }
            return nv.getValue();
        }

        public void setValueAt(Object aValue, int row, int col) {
            if (UrlEncodedPanel.this._editable && aValue instanceof String) {
                NamedValue nv = (NamedValue)UrlEncodedPanel.this._values.get(row);
                if (col == 0) {
                    UrlEncodedPanel.this._values.set(row, new NamedValue((String)aValue, nv.getValue()));
                } else {
                    UrlEncodedPanel.this._values.set(row, new NamedValue(nv.getName(), (String)aValue));
                }
                UrlEncodedPanel.this._modified = true;
                this.fireTableCellUpdated(row, col);
            }
        }

        public boolean isCellEditable(int row, int column) {
            return UrlEncodedPanel.this._editable;
        }
    }
}

