/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.ui.swing.editors.ObjectPanel;

public class SerializedObjectPanel
extends ObjectPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = -6252472359907569548L;
    private byte[] _data = new byte[0];
    private boolean _editable = false;
    private boolean _error = false;

    public SerializedObjectPanel() {
        this.setName("Serialized Object");
    }

    public String[] getContentTypes() {
        return new String[]{"application/x-serialized-object"};
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        super.setEditable(editable);
    }

    public void setBytes(String type, byte[] bytes) {
        this._data = bytes;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object o = ois.readObject();
            this.setObject(o);
            this._error = false;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "IOException deserializing the byte stream : " + ioe, "IOException", 0);
            this._error = true;
        }
        catch (ClassNotFoundException cnfe) {
            JOptionPane.showMessageDialog(null, "Class not found while deserializing the byte stream : " + cnfe, "Class not found", 0);
            this._error = true;
        }
        super.setEditable(this._editable && !this._error);
    }

    public byte[] getBytes() {
        if (this.isModified()) {
            try {
                Object o = this.getObject();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
                oos.flush();
                baos.flush();
                this._data = baos.toByteArray();
            }
            catch (IOException ioe) {
                System.err.println("Error serialising the object : " + ioe);
                return null;
            }
        }
        return this._data;
    }
}

