/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class RegexSearcher {
    private JTextComponent comp;
    private Highlighter.HighlightPainter matchPainter;
    private Highlighter.HighlightPainter selectionPainter;
    private int pos = -1;

    public RegexSearcher(JTextComponent comp, Color matchColor, Color selectionColor) {
        this.comp = comp;
        this.matchPainter = new DefaultHighlighter.DefaultHighlightPainter(matchColor);
        this.selectionPainter = new DefaultHighlighter.DefaultHighlightPainter(selectionColor);
    }

    public void search(String pattern, boolean caseSensitive) throws PatternSyntaxException {
        this.pos = -1;
        Highlighter highlighter = this.comp.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Highlighter.Highlight h = highlights[i];
            if (h.getPainter() != this.matchPainter && h.getPainter() != this.selectionPainter) continue;
            highlighter.removeHighlight(h);
        }
        if (pattern == null || "".equals(pattern)) {
            return;
        }
        String content = null;
        try {
            Document d = this.comp.getDocument();
            content = d.getText(0, d.getLength());
        }
        catch (BadLocationException e) {
            return;
        }
        int flags = 40;
        if (!caseSensitive) {
            flags |= 2;
        }
        Pattern p = Pattern.compile(pattern, flags);
        Matcher m = p.matcher(content);
        while (m.find()) {
            int i;
            int n = i = m.groupCount() > 0 ? 1 : 0;
            while (i <= m.groupCount()) {
                try {
                    highlighter.addHighlight(m.start(i), m.end(i), this.matchPainter);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public int previousMatch() {
        Highlighter highlighter = this.comp.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        Highlighter.Highlight last = null;
        Highlighter.Highlight previous = null;
        Highlighter.Highlight current = null;
        for (int i = 0; i < highlights.length; ++i) {
            Highlighter.Highlight h = highlights[i];
            if (h.getPainter() == this.matchPainter) {
                if (last == null || h.getStartOffset() > last.getStartOffset()) {
                    last = h;
                }
                if (h.getStartOffset() >= this.pos) continue;
                if (previous == null) {
                    previous = h;
                    continue;
                }
                if (previous.getStartOffset() >= h.getStartOffset()) continue;
                previous = h;
                continue;
            }
            if (h.getPainter() != this.selectionPainter) continue;
            current = h;
        }
        if (previous == null) {
            previous = last;
        }
        if (previous == null) {
            previous = current;
        }
        if (previous == null) {
            this.pos = -1;
        } else {
            if (previous != current) {
                try {
                    if (current != null) {
                        highlighter.removeHighlight(current);
                        highlighter.addHighlight(current.getStartOffset(), current.getEndOffset(), this.matchPainter);
                    }
                    highlighter.removeHighlight(previous);
                    highlighter.addHighlight(previous.getStartOffset(), previous.getEndOffset(), this.selectionPainter);
                    this.center(previous);
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
            this.pos = previous.getStartOffset();
        }
        return this.pos;
    }

    public int nextMatch() {
        Highlighter highlighter = this.comp.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        Highlighter.Highlight first = null;
        Highlighter.Highlight next = null;
        Highlighter.Highlight current = null;
        for (int i = 0; i < highlights.length; ++i) {
            Highlighter.Highlight h = highlights[i];
            if (h.getPainter() == this.matchPainter) {
                if (first == null || h.getStartOffset() < first.getStartOffset()) {
                    first = h;
                }
                if (h.getStartOffset() <= this.pos) continue;
                if (next == null) {
                    next = h;
                    continue;
                }
                if (next.getStartOffset() <= h.getStartOffset()) continue;
                next = h;
                continue;
            }
            if (h.getPainter() != this.selectionPainter) continue;
            current = h;
        }
        if (next == null) {
            next = first;
        }
        if (next == null) {
            next = current;
        }
        if (next == null) {
            this.pos = -1;
        } else {
            if (next != current) {
                try {
                    if (current != null) {
                        highlighter.removeHighlight(current);
                        highlighter.addHighlight(current.getStartOffset(), current.getEndOffset(), this.matchPainter);
                    }
                    highlighter.removeHighlight(next);
                    highlighter.addHighlight(next.getStartOffset(), next.getEndOffset(), this.selectionPainter);
                    this.center(next);
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
            this.pos = next.getStartOffset();
        }
        return this.pos;
    }

    private void center(Highlighter.Highlight match) throws BadLocationException {
        Rectangle r = this.comp.modelToView(match.getStartOffset());
        if (r == null) {
            return;
        }
        r.add(this.comp.modelToView(match.getEndOffset()));
        if (!this.comp.getVisibleRect().contains(r)) {
            this.center(r, false);
        }
    }

    private void center(Rectangle r, boolean withInsets) {
        Rectangle visible = this.comp.getVisibleRect();
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = this.comp.getBounds();
        Insets i = withInsets ? new Insets(0, 0, 0, 0) : this.comp.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        this.comp.scrollRectToVisible(visible);
    }
}

