/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class MyHTMLEditorKit
extends HTMLEditorKit {
    private static final long serialVersionUID = 2375665246506547467L;
    private static final ViewFactory defaultFactory = new MyHTMLFactory();

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    private static class NoView
    extends View {
        public NoView(Element elem) {
            super(elem);
            this.setSize(0.0f, 0.0f);
        }

        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            return 0;
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return new Rectangle(0, 0);
        }

        public float getPreferredSpan(int axis) {
            return 0.0f;
        }

        public void paint(Graphics g, Shape allocation) {
        }
    }

    private static class MyHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private MyHTMLFactory() {
        }

        public View create(Element elem) {
            HTML.Tag kind;
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag && ((kind = (HTML.Tag)o) == HTML.Tag.FRAME || kind == HTML.Tag.FRAMESET || kind == HTML.Tag.OBJECT || kind == HTML.Tag.MAP || kind == HTML.Tag.IMG || kind == HTML.Tag.LINK || kind == HTML.Tag.SCRIPT || kind == HTML.Tag.APPLET)) {
                return new NoView(elem);
            }
            return super.create(elem);
        }
    }
}

