/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.owasp.webscarab.model.Message;
import org.owasp.webscarab.model.MultiPartContent;
import org.owasp.webscarab.ui.swing.MessagePanel;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;

public class MultiPartPanel
extends JPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = 7790954945202743857L;
    private byte[] _data = null;
    private boolean _modified = false;
    private boolean _editable = false;
    private MultiPartContent _content = null;
    private PartsListModel _partsList = new PartsListModel();
    private int _selected = -1;
    private MessagePanel _mp = null;
    private JPanel contentPanel;
    private JScrollPane jScrollPane1;
    private JList partList;

    public MultiPartPanel() {
        this.initComponents();
        this.setName("MultiPart");
        this._mp = new MessagePanel(1);
        this.contentPanel.add(this._mp);
        this.partList.setModel(this._partsList);
        this.partList.setSelectionMode(0);
        this.partList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Message message;
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                if (MultiPartPanel.this._editable && MultiPartPanel.this._mp.isModified() && MultiPartPanel.this._selected > -1) {
                    MultiPartPanel.this._modified = true;
                    message = MultiPartPanel.this._mp.getMessage();
                    MultiPartPanel.this._content.set(MultiPartPanel.this._selected, message);
                    MultiPartPanel.this._partsList.fireContentsChanged(MultiPartPanel.this._selected, MultiPartPanel.this._selected);
                }
                MultiPartPanel.this._selected = MultiPartPanel.this.partList.getSelectedIndex();
                if (MultiPartPanel.this._selected < 0) {
                    return;
                }
                message = MultiPartPanel.this._content.get(MultiPartPanel.this._selected);
                MultiPartPanel.this._mp.setMessage(message);
                MultiPartPanel.this.invalidate();
                MultiPartPanel.this.revalidate();
            }
        });
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._mp.setEditable(editable);
    }

    public void setBytes(String contentType, byte[] bytes) {
        int size = 0;
        if (this._content != null) {
            size = this._content.size();
        }
        this._modified = false;
        this._data = bytes;
        this._content = new MultiPartContent(contentType, bytes);
        if (size > 0) {
            this._partsList.fireIntervalRemoved(0, size - 1);
        }
        if (this._content.size() > 0) {
            this._partsList.fireIntervalAdded(0, this._content.size() - 1);
        }
    }

    public boolean isModified() {
        return this._editable && (this._modified || this._mp.isModified());
    }

    public byte[] getBytes() {
        if (this._editable && this.isModified()) {
            if (this._mp.isModified()) {
                this._content.set(this._selected, this._mp.getMessage());
            }
            this._data = this._content.getBytes();
            this._modified = false;
        }
        return this._data;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.partList = new JList();
        this.contentPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(100, 22));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 131));
        this.jScrollPane1.setViewportView(this.partList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.contentPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.contentPanel, gridBagConstraints);
    }

    private class PartsListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 690901016063929348L;

        private PartsListModel() {
        }

        public Object getElementAt(int index) {
            return MultiPartPanel.this._content.getPartName(index);
        }

        public int getSize() {
            if (MultiPartPanel.this._content == null) {
                return 0;
            }
            return MultiPartPanel.this._content.size();
        }

        public void fireIntervalAdded(int index0, int index1) {
            super.fireIntervalAdded(this, index0, index1);
        }

        public void fireIntervalRemoved(int index0, int index1) {
            super.fireIntervalRemoved(this, index0, index1);
        }

        public void fireContentsChanged(int index0, int index1) {
            super.fireContentsChanged(this, index0, index1);
        }
    }
}

